#pragma once

#include "checker.h"

#include <vector>

namespace NPassport::NBb::NTotp {
    class TService;
}

namespace NPassport::NBb {
    class TTotpProfile {
    public:
        TTotpProfile(ui64 uid, const TString& pin);

        class TSecretData;

        NTotp::TTotpResult Check(const NTotp::TService& service,
                                 const TString& pwd,
                                 time_t lastValidTime,
                                 ui64 secretId) const;
        NTotp::TTotpResult Check(const NTotp::TService& service,
                                 const TString& pwd,
                                 time_t lastValidTime) const;

        bool IsInited() const;

        const TString& Pin() const {
            return Pin_;
        }

        ui64 Uid() const {
            return Uid_;
        }

        unsigned SecretCount() const {
            return Data_.size();
        }

        const TString& LastError() const {
            return LastError_;
        }

        TSecretData* AddSecret(const TString& secret, ui64 secretId, std::time_t created);
        bool DropSecret(ui64 secretId);

        // Diagnostics
        std::pair<bool, ui64> DiagSecret(const TString& secretToMatch, const TString& salt) const;
        std::pair<bool, ui64> DiagPinSecret(const TString& pairToMatch, const TString& salt) const;
        std::pair<bool, ui64> DiagTotp(const NTotp::TService& service,
                                       const TString& totpToMatch,
                                       time_t timestamp,
                                       const TString& salt) const;
        std::pair<time_t, ui64> DiagTime(const NTotp::TService& service,
                                         const TString& totpToMatch,
                                         const TString& skew,
                                         time_t timestamp,
                                         const TString& salt) const;

        ui64 OldestSecretId() const;

        // For synthetic attribute
        TString GetSecretInfo() const;

    protected:
        TSecretData* AddSecret();

        ui64 Uid_;
        TString Pin_;
        std::vector<TSecretData> Data_;
        TString LastError_;

        friend class TTotpEncryptor;
        friend class TSecretData;
    };

    class TTotpProfile::TSecretData {
    public:
        const TString& TotpKey(const TString& pin) const;
        const TString& Secret() const {
            return Secret_;
        }
        ui64 SecretId() const {
            return SecretId_;
        }
        std::time_t Created() const {
            return Created_;
        }

    protected:
        TSecretData() = default;

        mutable TString TotpKey_;
        mutable TString Pin_;
        TString Secret_;
        ui64 SecretId_ = 0;
        std::time_t Created_ = 0;

        friend class TTotpProfile;
        friend class TTotpEncryptor;
    };

}
