#include "error_stats.h"

#include <passport/infra/libs/cpp/unistat/builder.h>

namespace NPassport::NBb {
    void TErrorStats::IncCounter(TBlackboxError::EType error) {
        switch (error) {
            case TBlackboxError::EType::AccessDenied:
                ++AccessDenied_;
                break;
            case TBlackboxError::EType::DbException:
                ++DbException_;
                break;
            case TBlackboxError::EType::InvalidParams:
                ++InvalidParams_;
                break;
            case TBlackboxError::EType::Unknown:
                ++Unknown_;
                break;
            default:
                break;
        }
    }

    void TErrorStats::FillStats(NUnistat::TBuilder& builder) const {
        builder.Add(AccessDenied_);
        builder.Add(DbException_);
        builder.Add(Fatal_);
        builder.Add(InvalidParams_);
        builder.Add(Unknown_);
        builder.Add(UnrecognizedRequest_);
    }
}
