#pragma once

#include <passport/infra/daemons/blackbox/src/misc/exception.h>

#include <passport/infra/libs/cpp/unistat/diff.h>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NBb {
    struct TErrorStats {
        void IncCounter(TBlackboxError::EType error);

        void IncFatal() {
            ++Fatal_;
        }

        void IncUnrecognizedRequest() {
            ++UnrecognizedRequest_;
        }

        void FillStats(NUnistat::TBuilder& builder) const;

    private:
        NUnistat::TSignalDiff<> AccessDenied_ = {"error.accessdenied"};
        NUnistat::TSignalDiff<> DbException_ = {"error.dbexception"};
        NUnistat::TSignalDiff<> Fatal_ = {"error.fatal"};
        NUnistat::TSignalDiff<> InvalidParams_ = {"error.invalidparams"};
        NUnistat::TSignalDiff<> Unknown_ = {"error.unknown"};
        NUnistat::TSignalDiff<> UnrecognizedRequest_ = {"error.unrecognizedrequest"};
    };
}
