#include "method_counters.h"

#include <passport/infra/libs/cpp/unistat/builder.h>

namespace NPassport::NBb {
    void TMethodCounters::Add(const TString& method) {
        Data_.emplace(method, TSerializable(method));
    }

    void TMethodCounters::AddUnistat(NUnistat::TBuilder& builder) const {
        for (const auto& [method, serializable] : Data_) {
            builder.Add(*serializable.Counter);
        }
        builder.Add(Ping_);
        builder.Add(CheckGrants_);
        builder.Add(HealthCheck_);
    }

    void TMethodCounters::Inc(const TString& method) {
        auto it = Data_.find(method);
        if (it == Data_.end()) {
            return;
        }

        ++(*it->second.Counter);
    }

    void TMethodCounters::IncPing() {
        ++Ping_;
    }

    void TMethodCounters::IncCheckGrants() {
        ++CheckGrants_;
    }

    void TMethodCounters::IncHealthCheck() {
        ++HealthCheck_;
    }

    TMethodCounters::TSerializable::TSerializable(const TString& method)
        : Counter(std::make_unique<NUnistat::TSignalDiff<>>("method." + method))
    {
    }
}
