#pragma once

#include <passport/infra/libs/cpp/unistat/diff.h>

#include <unordered_map>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NBb {
    class TMethodCounters {
    public:
        void Add(const TString& method);

        void AddUnistat(NUnistat::TBuilder& builder) const;
        void Inc(const TString& method);
        void IncPing();
        void IncCheckGrants();
        void IncHealthCheck();

    private:
        struct TSerializable {
            TSerializable(const TString& method);

            std::unique_ptr<NUnistat::TSignalDiff<>> Counter;
        };

        std::unordered_map<TString, TSerializable> Data_;
        NUnistat::TSignalDiff<> Ping_ = {"handle_ping"};
        NUnistat::TSignalDiff<> CheckGrants_ = {"handle_check_grants"};
        NUnistat::TSignalDiff<> HealthCheck_ = {"handle_health_check"};
    };
}
