LIBRARY()

OWNER(g:passport_infra)

PEERDIR(
    contrib/libs/libiconv
    contrib/libs/libsodium
    contrib/libs/libxml
    contrib/libs/openssl
    passport/infra/libs/cpp/argon
    passport/infra/libs/cpp/phonenumber
    passport/infra/daemons/blackbox/src/crypt
    passport/infra/daemons/blackbox/src/protobuf
    passport/infra/libs/cpp/auth_core
    passport/infra/libs/cpp/cache
    passport/infra/libs/cpp/gamma_fetcher
    passport/infra/libs/cpp/juggler
    passport/infra/libs/cpp/xml
    passport/infra/libs/cpp/idn
    passport/infra/libs/cpp/tvm/dbpool
    passport/infra/libs/cpp/tvm/common
    passport/infra/libs/cpp/tvm/signer
    passport/infra/libs/cpp/tvm/logger
    passport/infra/libs/cpp/yp_cookie_parser
    passport/protobuf/billing_features
    passport/protobuf/plus_subscriber_state
    library/cpp/digest/old_crc
    library/cpp/geobase
    library/cpp/json
    library/cpp/openssl/holders
    library/cpp/string_utils/secret_string
)

SRCS(
badauth/async_db_writer.cpp
badauth/facade.cpp
badauth/helper.cpp
badauth/kolmogor.cpp
badauth/utils.cpp
blackbox.cpp
blackbox_impl.cpp
gammas/fetcher.cpp
grants/consumer.cpp
grants/consumer_info.cpp
grants/grants_checker.cpp
grants/ip_grants.cpp
grants/tvm_grants.cpp
helpers/account_helper.cpp
helpers/attributes_helper.cpp
helpers/base_result_helper.cpp
helpers/billing_features_helper.cpp
helpers/dbfields_helper.cpp
helpers/display_name_helper.cpp
helpers/email_attrs_helper.cpp
helpers/family_info_helper.cpp
helpers/karma_helper.cpp
helpers/oauth_attrs_helper.cpp
helpers/partitions_helper.cpp
helpers/phone_attrs_helper.cpp
helpers/plus_subscriber_state_helper.cpp
helpers/public_id_helper.cpp
helpers/strong_pwd_helper.cpp
helpers/test_pin_helper.cpp
helpers/uid_helper.cpp
helpers/webauthn_attrs_helper.cpp
loggers/authlog.cpp
loggers/tskvlog.cpp
methods/check_device_signature.cpp
methods/check_has_plus.cpp
methods/checkip.cpp
methods/check_rfc_totp.cpp
methods/check_sign.cpp
methods/create_oauth_token.cpp
methods/create_pwd_hash.cpp
methods/createsession.cpp
methods/decrease_sessionid_lifetime.cpp
methods/deletion_operations.cpp
methods/editsession.cpp
methods/edit_totp.cpp
methods/email_bindings.cpp
methods/family_info.cpp
methods/find_by_phone_numbers.cpp
methods/find_pdd_accounts.cpp
methods/generate_public_id.cpp
methods/get_all_tracks.cpp
methods/get_debug_user_ticket.cpp
methods/get_device_public_key.cpp
methods/get_max_uid.cpp
methods/get_oauth_tokens.cpp
methods/get_recovery_keys.cpp
methods/get_track.cpp
methods/hosted_domains.cpp
methods/lcookie.cpp
methods/login.cpp
methods/loginoccupation.cpp
methods/oauth.cpp
methods/phone_bindings.cpp
methods/phone_operations.cpp
methods/prove_key_diag.cpp
methods/pwdhistory.cpp
methods/sessionid.cpp
methods/sign.cpp
methods/test_pwd_hashes.cpp
methods/userinfo.cpp
methods/user_ticket.cpp
methods/webauthn_credentials.cpp
methods/yakey_backup.cpp
misc/anonymiser.cpp
misc/attributes.cpp
misc/db_fetcher.cpp
misc/dbfields_converter.cpp
misc/dbfields_settings.cpp
misc/db_profile.cpp
misc/db_types.cpp
domain/domain.cpp
domain/domain_list.cpp
domain/domain_builder.cpp
domain/domain_fetcher.cpp
misc/exception.cpp
misc/experiment.cpp
misc/hosts_list.cpp
misc/invalid_value.cpp
misc/lcookie_parser.cpp
misc/lrcs_cookie_parser.cpp
misc/partitions.cpp
misc/login_status.cpp
misc/lrandoms_dumper.cpp
misc/passport_wrapper.cpp
misc/password_checker.cpp
misc/perimeter.cpp
misc/rate_limiter.cpp
misc/response_cache.cpp
misc/sessguard_options.cpp
misc/session_utils.cpp
misc/sess_kill_wrapper.cpp
misc/shards_map.cpp
misc/signer.cpp
staff/staff_client.cpp
staff/staff_fetcher.cpp
staff/staff_info.cpp
misc/stopwords_list.cpp
misc/strings.cpp
misc/synthetic_attrs.cpp
misc/utils.cpp
misc/validator.cpp
misc/ya_domains.cpp
oauth/config.cpp
oauth/error.cpp
oauth/fetcher.cpp
oauth/multi_fetcher.cpp
oauth/scopes.cpp
oauth/status.cpp
oauth/token_embedded_info.cpp
oauth/token_info.cpp
output/json_serializer.cpp
output/out_tokens.cpp
output/xml_serializer.cpp
totp/hotp.cpp
totp/totp_encryptor.cpp
totp/totp_profile.cpp
unistat/consumer_stats.cpp
unistat/error_stats.cpp
unistat/method_counters.cpp
ip/ipacl_loader.cpp
ip/ipacl_utils.cpp
ip/ipacl_white_list.cpp
ip/usernets_list.cpp
)

GENERATE_ENUM_SERIALIZATION(blackbox_impl.h)
GENERATE_ENUM_SERIALIZATION(methods/sessionid.h)
GENERATE_ENUM_SERIALIZATION(domain/domain_builder.h)
GENERATE_ENUM_SERIALIZATION(domain/idomain_fetcher.h)
GENERATE_ENUM_SERIALIZATION(misc/perimeter.h)
GENERATE_ENUM_SERIALIZATION(misc/signer.h)
GENERATE_ENUM_SERIALIZATION(misc/utils.h)
GENERATE_ENUM_SERIALIZATION(oauth/error.h)
GENERATE_ENUM_SERIALIZATION(oauth/status.h)

END()
