# coding: utf-8

from libc.stdint cimport uint32_t
from libcpp.map cimport map as cmap
from util.generic.string cimport TString
from cython.operator cimport dereference

cdef extern from "passport/infra/libs/cpp/auth_core/keymap.h" namespace "NPassport::NAuth":
    cppclass TKeyMap:
        @staticmethod
        TKeyMap CreateFromFile(TString filename, int defaultid)

cdef extern from "passport/infra/daemons/blackbox/src/misc/password_checker.h" namespace "NPassport::NBb":
    cdef cppclass TPasswordChecker:
        TPasswordChecker(TKeyMap&& secrets, int hashlen, int tCost, int mCost)
        TString ConvertMD5ToArgon(TString md5, TString uid)
        TString ConvertRawMD5ToArgon(TString md5, TString uid)

cdef class Factory:
    cdef TPasswordChecker* baseptr
    def __cinit__(self, secrets, defaultid, hashlen, tCost, mCost):
        self.baseptr = new TPasswordChecker(TKeyMap.CreateFromFile(secrets.encode('utf-8'), defaultid), hashlen, tCost, mCost)

    def __dealloc__(self):
        del self.baseptr

    def convert(self, oldhash, uid):
        uid = str(uid)
        if oldhash.startswith('1:'):
            return self.md5_to_argon(oldhash[2:], uid)
        elif oldhash.startswith('3:'):
            return self.md5raw_to_argon(oldhash[2:], uid)

        raise ValueError('"%s" for uid="%s" has unsupported version' % (oldhash, uid))

    def md5_to_argon(self, md5, uid):
        return self.baseptr.ConvertMD5ToArgon(<TString>md5.encode('utf-8'), <TString>uid.encode('utf-8')).decode('utf-8')

    def md5raw_to_argon(self, md5, uid):
        return self.baseptr.ConvertRawMD5ToArgon(<TString>md5.encode('utf-8'), <TString>uid.encode('utf-8')).decode('utf-8')
