#include <passport/infra/daemons/blackbox/tools/auth2his_sampler/src/facade.h>

#include <passport/infra/libs/cpp/utils/log/global.h>

#include <library/cpp/getopt/small/last_getopt.h>

int main(int argc, char** argv) {
    TString configPath;

    try {
        NLastGetopt::TOpts opts;
        opts.AddHelpOption();
        opts.SetFreeArgsNum(0);
        opts.AddLongOption('c', "config", "")
            .StoreResult(&configPath)
            .DefaultValue("/etc/yandex/passport-auth2his-sampler.conf");

        NLastGetopt::TOptsParseResult res(&opts, argc, argv);

        NPassport::NA2h::TFacade facade(configPath);
        facade.Run();
    } catch (const std::exception& e) {
        NPassport::TLog::Error() << "main(): got exception, exiting: " << e.what() << Endl;
        return 1;
    }

    return 0;
}
