#pragma once

#include "parser.h"
#include "pipe.h"
#include "signaler.h"

#include <passport/infra/libs/cpp/xml/config.h>

namespace NPassport::NA2h {
    class TFacade {
    public:
        TFacade(const TString& configPath);

        void Run();

    private:
        static void InitLogs(const NXml::TConfig& cfg, const TString& xpath);
        static TParser CreateParser(const NXml::TConfig& cfg, const TString& xpath);
        static TSamplerStorage CreateStorage(const NXml::TConfig& cfg, const TString& xpath);
        static TSignalerPtr CreateSignaler(const NXml::TConfig& cfg, const TString& xpath, const size_t limit);

    private:
        std::unique_ptr<TPipe> Pipe_;
    };
}
