#pragma once

#include "storage.h"

#include <util/datetime/base.h>
#include <util/generic/strbuf.h>
#include <util/generic/string.h>

#include <vector>

namespace NPassport::NA2h {
    class TParser {
    public:
        TParser(TDuration samplingPeriod);

        enum class EStatus {
            Samplable,
            NotSamplable,
            Error,
        };

        EStatus ParseOAuthSuccessful(TStringBuf in, TString& entryKey);

    protected:
        void SplitToVector(TStringBuf in);
        static TStringBuf GetTokenidFromComment(TStringBuf comment);

    private:
        std::vector<TStringBuf> AllocatedVector_;
        ui32 SamplingPeriod_;
    };
}
