#pragma once

#include "parser.h"
#include "signaler.h"
#include "storage.h"

namespace NPassport::NA2h {
    class TPipe {
    public:
        TPipe(TParser&& parser, TSamplerStorage&& storage, TSignalerPtr signaler);

        void Run(IInputStream& in, IOutputStream& out);

        void Stop();

    protected:
        bool ProcessLine(TStringBuf line);

    private:
        TParser Parser_;
        TString EntryKey_;
        TSamplerStorage Storage_;
        TSignalerPtr Signaler_;
        std::atomic_bool Exit_ = {false};
    };
}
