#include "signaler.h"

#include <passport/infra/libs/cpp/json/writer.h>
#include <passport/infra/libs/cpp/utils/log/global.h>

namespace NPassport::NA2h {
    TSignaler::TSignaler(TKeepAliveHttpClient&& client,
                         const TString& path,
                         EXunistaterRequired required,
                         size_t limitSignal)
        : Client_(std::move(client))
        , Path_(path)
        , Required_(required)
    {
        Signals_.push_back({"all_dmmm"});
        Signals_.push_back({"parsingErrors_dmmm"});
        Signals_.push_back({"oauth.success.all_dmmm"});
        Signals_.push_back({"oauth.success.skipped_dmmm"});
        Y_VERIFY(Signals_.size() == (size_t)ESignal::__TOTAL);

        SignalStorageLimit_ = limitSignal;

        try {
            Push(BuildRequest());
        } catch (const std::exception& e) {
            TLog::Error() << "Signaler: " << e.what();
            if (Required_ == EXunistaterRequired::True) {
                throw;
            }
        }
    }

    void TSignaler::Run() {
        for (TDiffSignal& s : Signals_) {
            s.ToSend += s.Buffer->exchange(0);
        }

        Push(BuildRequest());

        for (TDiffSignal& s : Signals_) {
            s.ToSend = 0;
        }
    }

    void TSignaler::Add(TSignaler::ESignal sig, ui64 val) {
        *Signals_[(size_t)sig].Buffer += val;
    }

    void TSignaler::SetStorageSize(size_t size) {
        SignalStorageSize_ = size;
    }

    void TSignaler::Push(const TStringBuf body) {
        ResponseBuffer_.clear();
        TStringOutput resp(ResponseBuffer_);
        auto code = Client_.DoPost(Path_, body, &resp);
        Y_ENSURE(code == 200, "Signaler: failed to send signals to xunistater: " << ResponseBuffer_);
    }

    const TString& TSignaler::BuildRequest() {
        NJson::TWriter wr(RequestBuffer_);
        NJson::TObject root(wr);

        for (const TDiffSignal& s : Signals_) {
            NJson::TObject obj(root, s.Name);
            obj.Add("value", s.ToSend);
        }

        auto add = [&root](const NUnistat::TSignalAbsolute<>& sig) {
            NJson::TObject obj(root, sig.GetName());
            obj.Add("value", sig.GetValue());
        };
        add(SignalStorageSize_);
        add(SignalStorageLimit_);

        return RequestBuffer_;
    }
}
