#pragma once

#include <passport/infra/libs/cpp/unistat/absolute.h>
#include <passport/infra/libs/cpp/utils/atomic.h>
#include <passport/infra/libs/cpp/utils/regular_task.h>

#include <library/cpp/http/simple/http_client.h>

namespace NPassport::NA2h {
    class TSignaler {
    public:
        enum class ESignal {
            AllLines,
            ParsingErrors,
            OAuthSuccessAll,
            OAuthSuccessSkipped,
            __TOTAL,
        };

        enum class EXunistaterRequired {
            True,
            False,
        };

        TSignaler(TKeepAliveHttpClient&& client,
                  const TString& path,
                  EXunistaterRequired required,
                  size_t limitSignal);
        virtual ~TSignaler() = default;

        void Run();
        void Add(ESignal sig, ui64 val = 1);
        void SetStorageSize(size_t size);

    private:
        void Push(const TStringBuf body);
        const TString& BuildRequest();

    private:
        struct TDiffSignal {
            TDiffSignal(const TString& name)
                : Name(name)
                , Buffer(std::make_unique<NUtils::TAtomicNum<>>())
            {
            }

            TString Name;
            std::unique_ptr<NUtils::TAtomicNum<>> Buffer;
            ui64 ToSend = 0;
        };

    private:
        TKeepAliveHttpClient Client_;
        const TString Path_;
        const EXunistaterRequired Required_;
        std::vector<TDiffSignal> Signals_;
        NUnistat::TSignalAbsolute<> SignalStorageSize_ = {"oauth.storage.size"};
        NUnistat::TSignalAbsolute<> SignalStorageLimit_ = {"oauth.storage.limit"};

        TString RequestBuffer_;
        TString ResponseBuffer_;
    };
    using TSignalerPtr = std::unique_ptr<TSignaler>;
}
