#include "storage.h"

#include <passport/infra/libs/cpp/unistat/builder.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

namespace NPassport::NA2h {
    TSamplerStorage::TSamplerStorage(size_t limit)
        : Limit_(limit)
        , Data_(std::make_unique<TCache>(limit))
    {
        Y_ENSURE(Limit_ > 0, "SamplerStorage: limit cannot be 0");
    }

    size_t TSamplerStorage::size() const noexcept {
        return Data_->Size();
    }

    size_t TSamplerStorage::GetLimit() const {
        return Limit_;
    }

    TSamplerStorage::EStatus TSamplerStorage::TryAdd(const TString& entry) {
        if (Data_->Find(entry) != Data_->End()) {
            return EStatus::Exists;
        }

        Data_->Insert(entry, 0);
        return EStatus::Added;
    }

    TString TSamplerStorage::DumpForTests() const {
        std::vector<TString> tmp;
        for (auto it = Data_->Begin(); it != Data_->End(); ++it) {
            tmp.push_back(it.Key());
        }
        std::sort(tmp.begin(), tmp.end());

        TStringStream s;
        for (const auto& entry : tmp) {
            s << "{" << entry << "}" << Endl;
        }

        return s.Str();
    }
}
