#pragma once

#include <library/cpp/cache/cache.h>

namespace NPassport::NA2h {
    class TSamplerStorage: TMoveOnly {
        struct TSlice;

    public:
        TSamplerStorage(size_t limit);
        TSamplerStorage(TSamplerStorage&&) = default;

        size_t size() const noexcept;
        size_t GetLimit() const;

        enum class EStatus {
            Exists,
            Added,
        };
        EStatus TryAdd(const TString& entry);

    protected:
        TString DumpForTests() const;

    private:
        using TCache = TLRUCache<TString, char>;

        size_t Limit_;
        std::unique_ptr<TCache> Data_;
    };
}
