#include <passport/infra/daemons/blackbox/tools/auth2his_sampler/src/parser.h>

#include <passport/infra/libs/cpp/utils/log/global.h>
#include <passport/infra/libs/cpp/utils/log/logger.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/stream/file.h>
#include <util/system/fs.h>

using namespace NPassport;
using namespace NPassport::NA2h;

Y_UNIT_TEST_SUITE(PasspParser) {
    Y_UNIT_TEST(common) {
        TParser parser(TDuration::Seconds(3600));
        TString entryKey;

        // no magic prefix
        UNIT_ASSERT_VALUES_EQUAL(
            TParser::EStatus::Error,
            parser.ParseOAuthSuccessful("1 2019-09-04T19:35:44.315608+03 7F bb 4001096104 - - oauthcheck fail clid=5e8656ef62914d738a9865ebf1e999b9;tokid=15676149431234001096104;devid=ca2c4cfc56ed4465861356647d76865b;scope=test:limited; 127.0.0.1 - - - - -",
                                        entryKey));
        // not enough colomns
        UNIT_ASSERT_VALUES_EQUAL(
            TParser::EStatus::Error,
            parser.ParseOAuthSuccessful("x;y;z;1 2019-09-04T19:35:44.315608+03 7F bb 4001096104 - - oauthcheck fail clid=5e8656ef62914d738a9865ebf1e999b9;tokid=15676149431234001096104;devid=ca2c4cfc56ed4465861356647d76865b;scope=test:limited; 127.0.0.1 - - - -",
                                        entryKey));

        // oauth fail
        UNIT_ASSERT_VALUES_EQUAL(
            TParser::EStatus::NotSamplable,
            parser.ParseOAuthSuccessful("x;y;z;1 2019-09-04T19:35:44.315608+03 7F bb 4001096104 - - oauthcheck fail clid=5e8656ef62914d738a9865ebf1e999b9;tokid=15676149431234001096104;devid=ca2c4cfc56ed4465861356647d76865b;scope=test:limited; 127.0.0.1 - - - - -",
                                        entryKey));
        // not oauth
        UNIT_ASSERT_VALUES_EQUAL(
            TParser::EStatus::NotSamplable,
            parser.ParseOAuthSuccessful("x;y;z;1 2019-09-04T19:35:44.315608+03 7F bb 4001096104 - - sesscreate successful clid=5e8656ef62914d738a9865ebf1e999b9;tokid=15676149431234001096104;devid=ca2c4cfc56ed4465861356647d76865b;scope=test:limited; 127.0.0.1 - - - - -",
                                        entryKey));

        // no user ip
        UNIT_ASSERT_VALUES_EQUAL(
            TParser::EStatus::Error,
            parser.ParseOAuthSuccessful("x;y;z;1 2019-09-04T19:35:44.315608+03 7F bb 4001096104 - - oauthcheck successful clid=5e8656ef62914d738a9865ebf1e999b9;tokid=15676149431234001096104;devid=ca2c4cfc56ed4465861356647d76865b;scope=test:limited;  - - - - -",
                                        entryKey));
        UNIT_ASSERT_VALUES_EQUAL(
            TParser::EStatus::Error,
            parser.ParseOAuthSuccessful("x;y;z;1 2019-09-04T19:35:44.315608+03 7F bb 4001096104 - - oauthcheck successful clid=5e8656ef62914d738a9865ebf1e999b9;tokid=15676149431234001096104;devid=ca2c4cfc56ed4465861356647d76865b;scope=test:limited; - - - - - -",
                                        entryKey));

        // no token id
        UNIT_ASSERT_VALUES_EQUAL(
            TParser::EStatus::Error,
            parser.ParseOAuthSuccessful("x;y;z;1 2019-09-04T19:35:44.315608+03 7F bb 4001096104 - - oauthcheck successful clid=5e8656ef62914d738a9865ebf1e999b9;tid=15676149431234001096104;devid=ca2c4cfc56ed4465861356647d76865b;scope=test:limited; 0.0.0.0 - - - - -",
                                        entryKey));
        UNIT_ASSERT_VALUES_EQUAL(
            TParser::EStatus::Error,
            parser.ParseOAuthSuccessful("x;y;z;1 2019-09-04T19:35:44.315608+03 7F bb 4001096104 - - oauthcheck successful clid=5e8656ef62914d738a9865ebf1e999b9;tokid=;devid=ca2c4cfc56ed4465861356647d76865b;scope=test:limited; 0.0.0.0 - - - - -",
                                        entryKey));

        // bad time
        UNIT_ASSERT_VALUES_EQUAL(
            TParser::EStatus::Error,
            parser.ParseOAuthSuccessful("x;y;z;1 2019-09-04T19:35:44.315608+ 7F bb 4001096104 - - oauthcheck successful clid=5e8656ef62914d738a9865ebf1e999b9;tokid=15676149431234001096104;devid=ca2c4cfc56ed4465861356647d76865b;scope=test:limited; 0.0.0.0 - - - - -",
                                        entryKey));

        UNIT_ASSERT_VALUES_EQUAL(
            TParser::EStatus::Samplable,
            parser.ParseOAuthSuccessful("x;y;z;1 2019-09-04T19:35:44.315608+03 7F bb 4001096104 - - oauthcheck successful clid=5e8656ef62914d738a9865ebf1e999b9;tokid=15676149431234001096104;devid=ca2c4cfc56ed4465861356647d76865b;scope=test:limited; 0.0.13.0 - - - - -",
                                        entryKey));
        UNIT_ASSERT_VALUES_EQUAL("15676149431234001096104|0.0.13.0|1567612800", entryKey);
    }
}
