#include <passport/infra/daemons/blackbox/tools/auth2his_sampler/src/pipe.h>

#include <passport/infra/libs/cpp/utils/log/global.h>
#include <passport/infra/libs/cpp/utils/log/logger.h>

#include <library/cpp/testing/mock_server/server.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/stream/file.h>
#include <util/system/fs.h>

using namespace NPassport;
using namespace NPassport::NA2h;

Y_UNIT_TEST_SUITE(PasspPipe) {
    using TXuniData = std::vector<TString>;

    class TXunistater: public TRequestReplier {
        TXuniData& Data_;

    public:
        TXunistater(TXuniData& data)
            : Data_(data)
        {
        }

        bool DoReply(const TReplyParams& params) override {
            const TParsedHttpFull parsed(params.Input.FirstLine());

            const HttpCodes code = parsed.Path == "/push_unistat" ? HTTP_OK : HTTP_NOT_FOUND;
            if (code == HTTP_OK) {
                Data_.push_back(params.Input.ReadAll());
            }

            THttpResponse resp(code);
            resp.OutTo(params.Output);

            return true;
        }
    };

    TSignalerPtr CreateSignaler(ui16 port) {
        return std::make_unique<TSignaler>(
            TKeepAliveHttpClient("localhost", port),
            "/push_unistat",
            TSignaler::EXunistaterRequired::True,
            100);
    }

    Y_UNIT_TEST(common) {
        TXuniData data;

        TPortManager pm;
        ui16 port = pm.GetPort(80);
        NMock::TMockServer server(port, [&data]() { return new TXunistater(data); });

        TSignalerPtr sig = CreateSignaler(port);
        TSignaler* signaler = sig.get();
        TPipe pipe(TParser(TDuration::Seconds(500)),
                   TSamplerStorage(100),
                   std::move(sig));
        TStringStream in;
        TStringStream out;

        in << "x1;y1;z1;1 2119-09-04T19:35:44.315608+03 7F bb 4001096104 - - oauthcheck successful clid=5e8656ef62914d738a9865ebf1e999b9;tokid=15676149431234001096104;devid=ca2c4cfc56ed4465861356647d76865b;scope=test:limited; 0.0.13.0 - - - - -" << Endl;
        in << "x2;y2;z2;1 2119-09-04T19:35:44.315608+03 7F bb 4001096104 - - oauthcheck successful clid=5e8656ef62914d738a9865ebf1e999b9;tokid=15676149431234001096104;devid=ca2c4cfc56ed4465861356647d76865b;scope=test:limited; 0.0.13.0 - - - - -" << Endl;
        in << "x3;y3;z3;1 2119-09-04T19:35:44.315608+03 7F bb 4001096104 - - oauthcheck successful clid=5e8656ef62914d738a9865ebf1e999b9;tokid=25676149431234001096104;devid=ca2c4cfc56ed4465861356647d76865b;scope=test:limited; 0.0.13.0 - - - - -";

        pipe.Run(in, out);

        UNIT_ASSERT_VALUES_EQUAL(out.Str(),
                                 "x1;y1;z1;1 2119-09-04T19:35:44.315608+03 7F bb 4001096104 - - oauthcheck successful clid=5e8656ef62914d738a9865ebf1e999b9;tokid=15676149431234001096104;devid=ca2c4cfc56ed4465861356647d76865b;scope=test:limited; 0.0.13.0 - - - - -\n"
                                 "x3;y3;z3;1 2119-09-04T19:35:44.315608+03 7F bb 4001096104 - - oauthcheck successful clid=5e8656ef62914d738a9865ebf1e999b9;tokid=25676149431234001096104;devid=ca2c4cfc56ed4465861356647d76865b;scope=test:limited; 0.0.13.0 - - - - -\n");

        data.clear();
        signaler->Run();
        UNIT_ASSERT_VALUES_EQUAL(
            data,
            TXuniData({
                R"({"all_dmmm":{"value":3},"parsingErrors_dmmm":{"value":0},"oauth.success.all_dmmm":{"value":3},"oauth.success.skipped_dmmm":{"value":1},"oauth.storage.size_avvv":{"value":1},"oauth.storage.limit_avvv":{"value":100}})",
            }));
        data.clear();
    }
}
