#include <passport/infra/daemons/blackbox/tools/auth2his_sampler/src/signaler.h>

#include <passport/infra/libs/cpp/utils/log/global.h>
#include <passport/infra/libs/cpp/utils/log/logger.h>

#include <library/cpp/testing/mock_server/server.h>
#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <unordered_map>

using namespace NPassport;
using namespace NPassport::NA2h;

Y_UNIT_TEST_SUITE(PasspSignaler) {
    using TXuniData = std::vector<TString>;

    class TXunistater: public TRequestReplier {
        TXuniData& Data_;

    public:
        TXunistater(TXuniData& data)
            : Data_(data)
        {
        }

        bool DoReply(const TReplyParams& params) override {
            const TParsedHttpFull parsed(params.Input.FirstLine());

            const HttpCodes code = parsed.Path == "/push_unistat" ? HTTP_OK : HTTP_NOT_FOUND;
            if (code == HTTP_OK) {
                Data_.push_back(params.Input.ReadAll());
            }

            THttpResponse resp(code);
            resp.OutTo(params.Output);

            return true;
        }
    };

    Y_UNIT_TEST(common) {
        TXuniData data;

        TPortManager pm;
        ui16 port = pm.GetPort(80);
        NMock::TMockServer server(port, [&data]() { return new TXunistater(data); });

        TSignaler signaler(TKeepAliveHttpClient("localhost", port),
                           "/push_unistat",
                           TSignaler::EXunistaterRequired::True,
                           100);

        UNIT_ASSERT_VALUES_EQUAL(
            data,
            TXuniData({
                R"({"all_dmmm":{"value":0},"parsingErrors_dmmm":{"value":0},"oauth.success.all_dmmm":{"value":0},"oauth.success.skipped_dmmm":{"value":0},"oauth.storage.size_avvv":{"value":0},"oauth.storage.limit_avvv":{"value":100}})",
            }));
        data.clear();

        signaler.Run();
        signaler.Run();
        UNIT_ASSERT_VALUES_EQUAL(
            data,
            TXuniData({
                R"({"all_dmmm":{"value":0},"parsingErrors_dmmm":{"value":0},"oauth.success.all_dmmm":{"value":0},"oauth.success.skipped_dmmm":{"value":0},"oauth.storage.size_avvv":{"value":0},"oauth.storage.limit_avvv":{"value":100}})",
                R"({"all_dmmm":{"value":0},"parsingErrors_dmmm":{"value":0},"oauth.success.all_dmmm":{"value":0},"oauth.success.skipped_dmmm":{"value":0},"oauth.storage.size_avvv":{"value":0},"oauth.storage.limit_avvv":{"value":100}})",
            }));
        data.clear();

        signaler.Add(TSignaler::ESignal::ParsingErrors, 7);
        signaler.Run();
        signaler.Run();
        UNIT_ASSERT_VALUES_EQUAL(
            data,
            TXuniData({
                R"({"all_dmmm":{"value":0},"parsingErrors_dmmm":{"value":7},"oauth.success.all_dmmm":{"value":0},"oauth.success.skipped_dmmm":{"value":0},"oauth.storage.size_avvv":{"value":0},"oauth.storage.limit_avvv":{"value":100}})",
                R"({"all_dmmm":{"value":0},"parsingErrors_dmmm":{"value":0},"oauth.success.all_dmmm":{"value":0},"oauth.success.skipped_dmmm":{"value":0},"oauth.storage.size_avvv":{"value":0},"oauth.storage.limit_avvv":{"value":100}})",
            }));
        data.clear();

        signaler.Add(TSignaler::ESignal::AllLines, 1);
        signaler.Add(TSignaler::ESignal::ParsingErrors, 2);
        signaler.Add(TSignaler::ESignal::OAuthSuccessAll, 3);
        signaler.Add(TSignaler::ESignal::OAuthSuccessSkipped, 4);
        signaler.SetStorageSize(10500);
        signaler.Run();
        signaler.Run();
        UNIT_ASSERT_VALUES_EQUAL(
            data,
            TXuniData({
                R"({"all_dmmm":{"value":1},"parsingErrors_dmmm":{"value":2},"oauth.success.all_dmmm":{"value":3},"oauth.success.skipped_dmmm":{"value":4},"oauth.storage.size_avvv":{"value":10500},"oauth.storage.limit_avvv":{"value":100}})",
                R"({"all_dmmm":{"value":0},"parsingErrors_dmmm":{"value":0},"oauth.success.all_dmmm":{"value":0},"oauth.success.skipped_dmmm":{"value":0},"oauth.storage.size_avvv":{"value":10500},"oauth.storage.limit_avvv":{"value":100}})",
            }));
        data.clear();
    }

    Y_UNIT_TEST(required) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TSignaler(TKeepAliveHttpClient("localhost", 0),
                      "/push_unistat",
                      TSignaler::EXunistaterRequired::True,
                      100),
            yexception,
            "can not connect to ");

        UNIT_ASSERT_NO_EXCEPTION(
            TSignaler(TKeepAliveHttpClient("localhost", 0),
                      "/push_unistat",
                      TSignaler::EXunistaterRequired::False,
                      100));
    }
}
