#include <passport/infra/daemons/blackbox/tools/auth2his_sampler/src/storage.h>

#include <passport/infra/libs/cpp/utils/log/global.h>
#include <passport/infra/libs/cpp/utils/log/logger.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/stream/file.h>
#include <util/system/fs.h>

using namespace NPassport;
using namespace NPassport::NA2h;

Y_UNIT_TEST_SUITE(PasspStorage) {
    static const TString FILENAME = "./tmplog";
    class TSamplerStorageTest: public TSamplerStorage {
    public:
        using TSamplerStorage::DumpForTests;
        using TSamplerStorage::TSamplerStorage;
    };

    Y_UNIT_TEST(common) {
        TSamplerStorageTest storage(10);

        UNIT_ASSERT_VALUES_EQUAL("", storage.DumpForTests());

        const TString key1 = "key1";
        const TString key2 = "key2";

        UNIT_ASSERT_VALUES_EQUAL(TSamplerStorage::EStatus::Added,
                                 storage.TryAdd(key1));
        UNIT_ASSERT_VALUES_EQUAL(
            TStringBuilder()
                << "{key1}" << Endl,
            storage.DumpForTests());
        UNIT_ASSERT_VALUES_EQUAL(TSamplerStorage::EStatus::Exists,
                                 storage.TryAdd(key1));
        UNIT_ASSERT_VALUES_EQUAL(
            TStringBuilder()
                << "{key1}" << Endl,
            storage.DumpForTests());

        UNIT_ASSERT_VALUES_EQUAL(TSamplerStorage::EStatus::Added,
                                 storage.TryAdd(key2));
        UNIT_ASSERT_VALUES_EQUAL(
            TStringBuilder()
                << "{key1}" << Endl
                << "{key2}" << Endl,
            storage.DumpForTests());

        UNIT_ASSERT_VALUES_EQUAL(TSamplerStorage::EStatus::Added,
                                 storage.TryAdd("key3"));
        UNIT_ASSERT_VALUES_EQUAL(TSamplerStorage::EStatus::Added,
                                 storage.TryAdd("key4"));
        UNIT_ASSERT_VALUES_EQUAL(TSamplerStorage::EStatus::Added,
                                 storage.TryAdd("key5"));
        UNIT_ASSERT_VALUES_EQUAL(TSamplerStorage::EStatus::Added,
                                 storage.TryAdd("key6"));
        UNIT_ASSERT_VALUES_EQUAL(TSamplerStorage::EStatus::Added,
                                 storage.TryAdd("key7"));
        UNIT_ASSERT_VALUES_EQUAL(TSamplerStorage::EStatus::Added,
                                 storage.TryAdd("key8"));
        UNIT_ASSERT_VALUES_EQUAL(TSamplerStorage::EStatus::Added,
                                 storage.TryAdd("key9"));
        UNIT_ASSERT_VALUES_EQUAL(TSamplerStorage::EStatus::Added,
                                 storage.TryAdd("key10"));
        UNIT_ASSERT_VALUES_EQUAL(TSamplerStorage::EStatus::Added,
                                 storage.TryAdd("key11"));

        UNIT_ASSERT_VALUES_EQUAL(
            TStringBuilder()
                << "{key10}" << Endl
                << "{key11}" << Endl
                << "{key2}" << Endl
                << "{key3}" << Endl
                << "{key4}" << Endl
                << "{key5}" << Endl
                << "{key6}" << Endl
                << "{key7}" << Endl
                << "{key8}" << Endl
                << "{key9}" << Endl,
            storage.DumpForTests());

        UNIT_ASSERT_VALUES_EQUAL(TSamplerStorage::EStatus::Added,
                                 storage.TryAdd("key1"));
        UNIT_ASSERT_VALUES_EQUAL(
            TStringBuilder()
                << "{key1}" << Endl
                << "{key10}" << Endl
                << "{key11}" << Endl
                << "{key3}" << Endl
                << "{key4}" << Endl
                << "{key5}" << Endl
                << "{key6}" << Endl
                << "{key7}" << Endl
                << "{key8}" << Endl
                << "{key9}" << Endl,
            storage.DumpForTests());
    }
}
