#include <passport/infra/daemons/blackbox/src/misc/utils.h>
#include <passport/infra/daemons/blackbox/src/totp/totp.h>

#include <passport/infra/libs/cpp/utils/string/coder.h>

#include <util/string/cast.h>

using NPassport::NBb::NRfc4226::THotpFactory;
using NPassport::NBb::NRfc6238::TTotp;
using NPassport::NBb::NRfc6238::TTotpFactory;

const TString USAGE_STR = "gen-totp <length> <secret_in_base64> [<time>] [Digits|Letters]";

int main(int argc, char* argv[]) {
    if (argc < 3) {
        Cerr << "Usage: " << USAGE_STR << Endl;
        return -1;
    }
    const std::size_t len = IntFromString<size_t, 10>(TStringBuf(argv[1]));
    const TString secret = NPassport::NUtils::Base64ToBin(argv[2]);
    time_t keyTime = std::time(nullptr);
    THotpFactory::EHotpType type = THotpFactory::Digits;
    if (argc > 3) {
        keyTime = NPassport::NBb::TUtils::ToTime(argv[3]);
    }
    if (argc > 4) {
        TString arg(argv[4]);
        if (arg == "Digits") {
            type = THotpFactory::Digits;
        } else if (arg == "Letters") {
            type = THotpFactory::Letters;
        } else {
            Cerr << "Wrong TOTP type: " << arg << Endl;
            Cerr << "Usage: " << USAGE_STR << Endl;
            return -1;
        }
    }

    try {
        Cout << TTotpFactory::GenTotp(len, type, secret, keyTime) << Endl;
    } catch (const std::exception& e) {
        Cerr << "Error: " << e.what() << Endl;
    }
    return 0;
}
