#include <passport/infra/daemons/blackbox/src/grants/consumer.h>
#include <passport/infra/daemons/blackbox/src/grants/ip_grants.h>

#include <passport/infra/libs/cpp/utils/log/devnull_logger.h>
#include <passport/infra/libs/cpp/utils/log/global.h>

#include <library/cpp/getopt/small/last_getopt.h>

int main(int argc, char** argv) {
    try {
        NLastGetopt::TOpts opts;
        opts.AddHelpOption();
        opts.AddLongOption("file", "path to file with grants").Required();
        opts.AddLongOption("ip", "ip to check").Required();
        NLastGetopt::TOptsParseResult res(&opts, argc, argv);

        using namespace NPassport;
        using namespace NPassport::NBb;
        using namespace NPassport::NUtils;

        TLog::Init(std::make_unique<NUtils::TDevNullLogger>());
        TIpGrants grants(res.Get("file"), TDuration::Days(1));

        TIpAddr ip;
        Y_ENSURE(ip.Parse(res.Get("ip")));

        TIpAclMap<TConsumer>::EStorage storage;
        std::shared_ptr<TConsumer> consumer = grants.Find(ip, &storage);

        if (!consumer) {
            Cout << "Peer was not found" << Endl;
        } else {
            Cout << "Peer was found: " << consumer->GetName() << Endl;
            Cout << "Peer was found by: ";
            switch (storage) {
                case TIpAclMap<TConsumer>::EStorage::Range:
                    Cout << "range of ip addrs";
                    break;
                case TIpAclMap<TConsumer>::EStorage::Single:
                    Cout << "signle ip addr";
                    break;
                case TIpAclMap<TConsumer>::EStorage::Trypo:
                    Cout << "trypo nets";
                    break;
            }
            Cout << Endl;

            Cout << consumer->ToString() << Endl;
        }

    } catch (const std::exception& e) {
        Cerr << e.what() << Endl;
        return 1;
    }

    return 0;
}
