#include <passport/infra/libs/cpp/auth_core/public_id.h>
#include <passport/infra/libs/cpp/auth_core/public_id_encryptor.h>
#include <passport/infra/libs/cpp/utils/string/coder.h>
#include <passport/infra/libs/cpp/utils/string/format.h>
#include <passport/infra/libs/cpp/utils/string/split.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

using namespace NPassport;

// NOLINTNEXTLINE(bugprone-exception-escape)
int main(int argc, char** argv) {
    TString keyfile = "/etc/fastcgi2/available/blackbox_keys/public_id_aes.keys";
    if (argc > 1) {
        keyfile = TString(argv[1]);
    }

    NAuth::TPublicIdEncryptor enc(NAuth::TKeyMap::CreateFromFile(keyfile, 0));

    TString line;
    while (Cin.ReadLine(line) > 0) {
        std::vector<TString> val = NUtils::ToVector(line, '\t');
        // Cout <<" Line, uid=" << val[0] << ", val=" << val[2] << Endl;

        NAuth::TPublicId id = enc.Decrypt(val[2]);
        if (id.Status() == NAuth::TPublicId::VALID) {
            Cout << "Valid public_id at uid=" << val[0] << ", type=" << val[1] << ", value='" << val[2]
                 << "', public_id ver=" << (int)id.Version() << ", public_id uid=" << id.Uid() << Endl;
        }
    }
}
