#include <passport/infra/daemons/blackbox/tools/reporter/access_log/src/mapper.h>
#include <passport/infra/daemons/blackbox/tools/reporter/access_log/src/reducer.h>

#include <library/cpp/getopt/small/last_getopt.h>

#include <util/datetime/base.h>
#include <util/stream/output.h>
#include <util/system/info.h>

using namespace NPassport;
using namespace NPassport::NBbAccess;

// NOLINTNEXTLINE(bugprone-exception-escape)
int main(int argc, char** argv) {
    size_t threads = std::min(NSystemInfo::NumberOfCpus(), size_t(60));
    TString date = (TInstant::Now() - TDuration::Days(1)).FormatLocalTime("%Y%m%d");

    NLastGetopt::TOpts opts;
    opts.AddHelpOption();
    opts.AddLongOption("outdir", "dir for out files").DefaultValue("./");
    opts.AddLongOption("date", "date: %Y%m%d (default: yesterday)").StoreResult(&date);
    opts.AddLongOption("storage", "path to dir with logs").DefaultValue("/storage/logs/");
    opts.AddCharOption('j', "threads (default: min(`nproc`, 60))").StoreResult(&threads);
    NLastGetopt::TOptsParseResult optRes(&opts, argc, argv);
    TString storage = optRes.Get("storage");
    TString outdir = optRes.Get("outdir");

    Cout << "Threads: " << threads << Endl;
    Cout << "Date   : " << date << Endl;
    Cout << "Start  : " << TInstant::Now() << Endl;

    Cout << "Start mapping" << Endl;
    TInstant startMapping = TInstant::Now();
    TMapper::TRes mapResult = NReporter::TMapper::Run<TParser, TStats>(
        NReporter::TMapper::GetLogList(storage, date, "blackbox-access.log", {"*load*", "*stress*"}),
        threads);
    Cout << "Mapping finished: " << (TInstant::Now() - startMapping) << Endl;

    Cout << "Start reducing" << Endl;
    TInstant startReducing = TInstant::Now();
    TReducer::Run(outdir, std::move(mapResult), date);
    Cout << "Reducing finished: " << (TInstant::Now() - startReducing) << Endl;

    Cout << "Finish: " << TInstant::Now() << Endl;

    return 0;
}
