#include "method.h"

#include "utils.h"

namespace NPassport::NBbAccess {
    void TMethod::Reserve() {
        Consumers_.reserve(10000);
    }

    void TMethod::Map(TStringBuf consumer, TConsumer::TData& data) {
        auto it = Consumers_.find(consumer);
        if (it == Consumers_.end()) {
            it = Consumers_.emplace(consumer, TConsumer()).first;
            it->second.Reserve();
        }

        ++TotalRequests_;
        it->second.Map(data);
    }

    void TMethod::Reduce(TMethod& to) const {
        to.TotalRequests_ += TotalRequests_;
        ReduceKv(Consumers_, to.Consumers_);
    }

    void TMethod::PrintRaw(TStringBuf grantType, TStringBuf method, IOutputStream& stream) const {
        for (const auto& [key, value] : SortCont(Consumers_)) {
            value->PrintRaw(grantType, method, key, stream);
        }
    }

    void TMethod::PrintPretty(TStringBuf method, ui64 totalStats, IOutputStream& stream) const {
        TVector<const TCont::value_type*> sorted;
        sorted.reserve(Consumers_.size());
        for (const auto& pair : Consumers_) {
            sorted.push_back(&pair);
        }
        std::sort(sorted.begin(), sorted.end(), [](const auto l, const auto r) -> bool {
            if (l->second.TotalRequests() == r->second.TotalRequests()) {
                return l->first < r->first;
            }
            return l->second.TotalRequests() > r->second.TotalRequests();
        });

        stream << "--------------- " << method << " " << MakeRatio(TotalRequests_, totalStats) << Endl;
        for (const TCont::value_type* pair : sorted) {
            pair->second.PrintPretty(pair->first, TotalRequests_, stream);
        }
    }

}
