#pragma once

#include "consumer.h"

#include <unordered_map>

namespace NPassport::NBbAccess {
    class TMethod { // NOLINT(bugprone-exception-escape)
        using TCont = THashMap<TString, TConsumer>;

    public:
        void Reserve();

        void Map(TStringBuf consumer, TConsumer::TData& data);
        void Reduce(TMethod& to) const;
        void PrintRaw(TStringBuf grantType, TStringBuf method, IOutputStream& stream) const;
        void PrintPretty(TStringBuf method, ui64 totalStats, IOutputStream& stream) const;

        ui64 TotalRequests() const {
            return TotalRequests_;
        }

    private:
        TCont Consumers_;
        ui64 TotalRequests_ = 0;
    };
}
