#include "parser.h"

#include <passport/infra/libs/cpp/utils/string/string_utils.h>

namespace NPassport::NBbAccess {
    TParser::TParser(const TString& filename)
        : TParserBase(filename)
    {
        Params_.reserve(100);
    }

    void TParser::ParseLine(TStringBuf line) {
        Params_.clear();
        GetParams_.clear();
        ParseLine(line, Stats_, Params_, GetParams_);
    }

    void TParser::ParseLine(TStringBuf line,
                            TStats& stats,
                            TCgiParams& outParams,
                            TCgiParams& outGetParams) {
        const TStringBuf fullLine = line;

        TStringBuf date = line.NextTok(' ');
        TStringBuf time = line.NextTok(' ');

        const char delim = '\t';

        TStringBuf requestId = line.NextTok(delim);
        TStringBuf schema = line.NextTok(delim);
        TStringBuf ip = line.NextTok(delim);
        TStringBuf respTime = line.NextTok(delim);
        TStringBuf consumer = line.NextTok(delim);
        TStringBuf respSize = line.NextTok(delim);
        TStringBuf cacheHit = line.NextTok(delim);
        TStringBuf requestNumber = line.NextTok(delim);

        // through one connection
        if (requestNumber == "-") {
            requestNumber = TStringBuf();
        }

        auto parseParams = [](TStringBuf in, TCgiParams& out) {
            if (in == "-") {
                return;
            }
            while (in) {
                TStringBuf value = in.NextTok('&');
                TStringBuf key = value.NextTok('=');
                out.emplace(key, value);
            }
        };

        const TStringBuf getParams = line.NextTok(delim);
        parseParams(getParams, outParams);
        parseParams(getParams, outGetParams); // TODO: avoid duplication of get params

        const TStringBuf postParams = line;
        parseParams(postParams, outParams);

        TConsumer::TData data;
        data.IsHttps = schema == "https";
        data.IsCacheHit = cacheHit == "h";
        data.Params = &outParams;
        data.GetParams = &outGetParams;
        data.RespTime = GetRespTime(respTime);
        data.RespSize = IntFromString<TRespSize, 10>(respSize);
        data.Ip = ip;
        if (requestNumber) {
            data.RequestNumberThroughOneConnection = IntFromString<ui32, 10>(requestNumber);
        }
        data.Line = fullLine;

        stats.Map(consumer, data);

        Y_UNUSED(date);
        Y_UNUSED(time);
        Y_UNUSED(requestId);
    }

    TDuration TParser::GetRespTime(TStringBuf str) {
        TDuration res = TDuration::MilliSeconds(IntFromString<ui32, 10>(str.NextTok('.')));
        res += TDuration::MicroSeconds(IntFromString<ui32, 10>(str) * 100);
        return res;
    }
}
