#pragma once

#include "stats.h"

#include <passport/infra/libs/cpp/reporter/parser.h>

#include <util/stream/file.h>
#include <util/stream/zlib.h>

namespace NPassport::NBbAccess {
    class TParser: public NReporter::TParserBase {
    public:
        TParser(const TString& filename);

        TStats FetchStats() {
            return std::move(Stats_);
        }

        void ParseLine(TStringBuf line) override;

    protected:
        static void ParseLine(TStringBuf line,
                              TStats& stats,
                              TCgiParams& params,
                              TCgiParams& outGetParams);
        static TDuration GetRespTime(TStringBuf str);

    private:
        TStats Stats_;
        TCgiParams Params_;
        TCgiParams GetParams_;
    };
}
