#include "reducer.h"

namespace NPassport::NBbAccess {
    void TReducer::Run(const TString& dir, TMapper::TRes&& mapRes, const TString& date) {
        TMapper::TRes prod;
        TMapper::TRes yateam;
        TMapper::TRes mimino;
        MakeStatGroups(std::move(mapRes), prod, yateam, mimino);

        TStats sProd = ReduceStatsGroup(std::move(prod));
        TStats sYateam = ReduceStatsGroup(std::move(yateam));
        TStats sMimino = ReduceStatsGroup(std::move(mimino));

        auto printRaw = [dir](const TStats& s, TString env) {
            TString fname = dir + "/raw." + env;
            TFileOutput f(fname);
            s.PrintRaw(f);
            Cout << "Raw stats writen to " << fname << Endl;
        };

        printRaw(sProd, "prod");
        printRaw(sYateam, "yateam");
        printRaw(sMimino, "mimino");

        auto printPretty = [dir, date](const TStats& s, TString env) {
            TFileOutput res(dir + "/result." + env + ".txt");
            const TStringBuf stars = " ********************************* ";
            res << stars << env << " *** " << date << stars << Endl;
            s.PrintPretty(res);
            res << Endl << Endl;
        };

        printPretty(sProd, "prod");
        printPretty(sYateam, "yateam");
        printPretty(sMimino, "mimino");

        auto printSessguard = [dir, date](const TStats& s, TString env) {
            TString fname = dir + "/raw.sessguard." + env;
            TFileOutput f(fname);
            s.PrintSessguard(f);
            Cout << "Sessguard stats writen to " << fname << Endl;
        };

        printSessguard(sProd, "prod");
        printSessguard(sYateam, "yateam");
        printSessguard(sMimino, "mimino");
    }

    void TReducer::MakeStatGroups(TMapper::TRes&& mapRes,
                                  TMapper::TRes& prod,
                                  TMapper::TRes& yateam,
                                  TMapper::TRes& mimino) {
        for (auto& pair : mapRes) {
            const TString& filename = pair.first;

            if (filename.Contains("pass-load") || filename.Contains("pass-stress")) {
                continue;
            }

            if (filename.Contains("pass-mimino")) {
                mimino.insert(std::move(pair));
            } else if (filename.Contains("pass-yateam")) {
                yateam.insert(std::move(pair));
            } else {
                prod.insert(std::move(pair));
            }
        }
    }

    TStats TReducer::ReduceStatsGroup(TMapper::TRes&& group) {
        TStats res;

        for (auto& pair : group) {
            pair.second.Reduce(res);
        }

        return res;
    }
}
