#pragma once

#include "consumer.h"

namespace NPassport::NBbAccess {
    enum EGrantType {
        Ip,
        Tvm,
    };

    template <class Str>
    struct TSesguardKey {
        Str GuardSpace;
        Str Host;
        EGrantType GrantType;
        Str Consumer;
        Str Method;

        template <class OtherStr>
        bool operator==(const TSesguardKey<OtherStr>& o) const {
            return GuardSpace == o.GuardSpace &&
                   Host == o.Host &&
                   GrantType == o.GrantType &&
                   Consumer == o.Consumer &&
                   Method == o.Method;
        }
    };
}

template <>
struct THash<NPassport::NBbAccess::TSesguardKey<TString>> {
    template <class OtherStr>
    size_t operator()(const NPassport::NBbAccess::TSesguardKey<OtherStr>& t) const {
        return THash<TStringBuf>()(t.GuardSpace) +
               THash<TStringBuf>()(t.Host) +
               THash<int>()(t.GrantType) +
               THash<TStringBuf>()(t.Consumer) +
               THash<TStringBuf>()(t.Method);
    }
};

template <>
struct TEqualTo<NPassport::NBbAccess::TSesguardKey<TString>> {
    template <class SomeStr, class OtherStr>
    bool operator()(const NPassport::NBbAccess::TSesguardKey<SomeStr>& a,
                    const NPassport::NBbAccess::TSesguardKey<OtherStr>& b) const {
        return a == b;
    }
};

namespace NPassport::NBbAccess {
    class TSessguardConfigReader;

    class TSessguardStats { // NOLINT(bugprone-exception-escape)
    public:
        TSessguardStats();

        void Map(EGrantType gt, TStringBuf consumer, TStringBuf method, const TConsumer::TData& data);
        void Reduce(TSessguardStats& to) const;

        void PrintTskv(IOutputStream& stream) const;

    public:
        struct TCounters {
            size_t Total = 0;
            size_t WithAnySessguard = 0;
            size_t WithNonEmptySessgaurd = 0;
            std::vector<TString> ExamplesWithoutSessguard;
            std::vector<TString> ExamplesWithEmptySessguard;

            void Add(const TCounters& o);
        };

        static TStringBuf GetHost(const TConsumer::TData& data);
        TStringBuf DetectGuardSpace(TStringBuf host) const;
        TCounters& GetCounters(EGrantType gt,
                               TStringBuf consumer,
                               TStringBuf method,
                               TStringBuf host,
                               TStringBuf guardSpace);

    private:
        THashMap<TSesguardKey<TString>, TCounters> Stats_;
        std::unique_ptr<TSessguardConfigReader> Config_;
    };

    class TSessguardConfigReader {
    public:
        using TGuards = THashMap<TString, TString>;

        TSessguardConfigReader();

        const TGuards* GetGuards(TStringBuf sld) const;

    private:
        static TGuards BuildGuards(TStringBuf config);

    private:
        TGuards ProdGuards_;
        TGuards YateamGuards_;
    };
}
