#pragma once

#include "method.h"
#include "sessguard.h"

#include <util/generic/noncopyable.h>

namespace NPassport::NBbAccess {
    class TStats: TMoveOnly {
        using TStatsByConsumer = THashMap<TString, TMethod>;

    public:
        TStats();
        TStats(TStats&&) = default; // NOLINT(bugprone-exception-escape)
        virtual ~TStats() = default;

        TStats& operator=(TStats&&) = default;

        virtual void Map(TStringBuf consumer, TConsumer::TData& data);

        void Reduce(TStats& to) const;
        void PrintRaw(IOutputStream& stream) const;
        void PrintPretty(IOutputStream& stream) const;
        void PrintSessguard(IOutputStream& stream) const;

    protected:
        static TStringBuf GetMethod(TCgiParams& params);

    private:
        TStatsByConsumer Ip_;
        TStatsByConsumer Tvm2_;
        TStatsByConsumer Unrecognized_;
        ui64 TotalRequests_ = 0;

        TSessguardStats Sessguard_;
    };
}
