#include "utils.h"

#include <util/stream/format.h>

namespace NPassport::NBbAccess {
    TString MakeRatio(ui64 part, ui64 total) {
        TStringStream s;
        s << Prec(total ? 100. * part / total : 0, PREC_POINT_DIGITS, 1) << "% ";
        s << "(" << Prec(part / (3600. * 12), PREC_POINT_DIGITS, 1) << "rps[12h] - "
          << Prec(part / (3600. * 24), PREC_POINT_DIGITS, 1) << "rps[24h] - "
          << part << "/" << total << ")";
        return s.Str();
    }
}
