#pragma once

#include <util/generic/string.h>

#include <unordered_map>

namespace NPassport::NBbAccess {
    TString MakeRatio(ui64 part, ui64 total);

    template <class T>
    void ReduceKv(const T& from, T& to) {
        for (auto& pairFrom : from) {
            auto itTo = to.find(pairFrom.first);
            if (itTo == to.end()) {
                to.insert(pairFrom);
            } else {
                pairFrom.second.Reduce(itTo->second);
            }
        }
    }

    template <class Key, class Value>
    std::vector<std::pair<Key, const Value*>> SortCont(const THashMap<Key, Value>& cont) {
        std::vector<std::pair<Key, const Value*>> res;
        res.reserve(cont.size());

        for (const auto& pair : cont) {
            res.push_back({pair.first, &pair.second});
        }

        std::sort(res.begin(), res.end(), [](const auto& l, const auto& r) { return l.first < r.first; });

        return res;
    }
}
