#include <passport/infra/daemons/blackbox/tools/reporter/access_log/src/consumer.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/string.h>

using namespace NPassport::NBbAccess;

Y_UNIT_TEST_SUITE(Consumer) {
    class TTestConsumer: public TConsumer {
    public:
        using TConsumer::GetHostFromRequest;
        using TConsumer::SerializeSet;
    };

    Y_UNIT_TEST(serializeSet) {
        TConsumer::TSet testSet;

        UNIT_ASSERT_VALUES_EQUAL("", TTestConsumer::SerializeSet(testSet));

        testSet.insert("kek");
        UNIT_ASSERT_VALUES_EQUAL("a2VrCg==", TTestConsumer::SerializeSet(testSet));

        testSet.insert("kek2");
        UNIT_ASSERT_VALUES_EQUAL("a2VrMgprZWsK", TTestConsumer::SerializeSet(testSet));

        testSet.insert("kek3");
        UNIT_ASSERT_VALUES_EQUAL("a2VrMwprZWsyCmtlawo=", TTestConsumer::SerializeSet(testSet));
    }

    Y_UNIT_TEST(getHostFromRequest) {
        auto check = [](TStringBuf value) {
            return TTestConsumer::GetHostFromRequest(TCgiParams{{"host", value}});
        };
        auto checkEq = [&](TStringBuf value) {
            auto res = check(value);
            UNIT_ASSERT(res);
            return *res;
        };

        UNIT_ASSERT(!check(""));
        UNIT_ASSERT(!check("."));

        UNIT_ASSERT_VALUES_EQUAL("yandex", checkEq(".yandex"));
        UNIT_ASSERT_VALUES_EQUAL("yandex", checkEq("yandex.ru"));
        UNIT_ASSERT_VALUES_EQUAL("yandex", checkEq("yandex.com"));
        UNIT_ASSERT_VALUES_EQUAL("yandex", checkEq("yandex.com.tr"));
        UNIT_ASSERT_VALUES_EQUAL("yandex", checkEq("yandex.co.li"));
        UNIT_ASSERT(!check(".yandex.co.li.kek"));

        UNIT_ASSERT_VALUES_EQUAL("mail.yandex", checkEq("mail.yandex.co.li"));
        UNIT_ASSERT_VALUES_EQUAL("mail.yandex", checkEq(".mail.yandex.co.li"));

        UNIT_ASSERT(!check(".yandex.strange.com"));

        UNIT_ASSERT_VALUES_EQUAL("something.beru.ru", checkEq("something.beru.ru"));
        UNIT_ASSERT_VALUES_EQUAL("something.edadeal.ru", checkEq("something.edadeal.ru"));
        UNIT_ASSERT_VALUES_EQUAL("something.edastage.ru", checkEq("something.edastage.ru"));
        UNIT_ASSERT_VALUES_EQUAL("something.kinopoisk.ru", checkEq("something.kinopoisk.ru"));
        UNIT_ASSERT_VALUES_EQUAL("something.yandexsport.ru", checkEq("something.yandexsport.ru"));

        UNIT_ASSERT_VALUES_EQUAL("beru.ru", checkEq("beru.ru"));
        UNIT_ASSERT(!check("something_beru.ru"));
    }
}
