#include <passport/infra/daemons/blackbox/tools/reporter/access_log/src/parser.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NBbAccess;

Y_UNIT_TEST_SUITE(Parser) {
    class TTestStats: public TStats {
    public:
        void Map(TStringBuf consumer, TConsumer::TData& data) override {
            Consumer = consumer;
            IsHttps = data.IsHttps;
            IsCacheHit = data.IsCacheHit;
            Params = *data.Params;
            RespTime = data.RespTime;
            RespSize = data.RespSize;
            Ip = data.Ip;
            Line = data.Line;
        }

        TString Consumer;
        bool IsHttps = false;
        bool IsCacheHit = false;
        TCgiParams Params;
        TDuration RespTime;
        TRespSize RespSize = 0;
        TString Ip;
        TString Line;
    };

    class TTestParser: public TParser {
    public:
        using TParser::GetRespTime;
        using TParser::ParseLine;
    };

    Y_UNIT_TEST(getRespTime) {
        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(1) + TDuration::MicroSeconds(500),
                                 TTestParser::GetRespTime("1.5"));
        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(100), TTestParser::GetRespTime("100.0"));
        UNIT_ASSERT_VALUES_EQUAL(TDuration::MicroSeconds(900), TTestParser::GetRespTime("0.9"));
    }

    Y_UNIT_TEST(parseLine) {
        TString line;
        TTestStats stats;
        TCgiParams tmpParams;
        TCgiParams tmpGetParams;
        line = "2019-03-13 "
               "15:40:09 "
               "e7289ef6ff2e3e4f\t"
               "https\t"
               "2a02:6b8:c02:500:8000:611:0:1d\t"
               "30.6\t"
               "1:passport_dev:2\t"
               "117\t"
               "h\t"
               "-\t"
               "format=xml&login=bbtst disabled\t"
               "method=login&password=*&userip=213.180.194.68";
        TTestParser::ParseLine(line, stats, tmpParams, tmpGetParams);

        UNIT_ASSERT_VALUES_EQUAL("1:passport_dev:2", stats.Consumer);
        UNIT_ASSERT_VALUES_EQUAL(true, stats.IsHttps);
        UNIT_ASSERT_VALUES_EQUAL(true, stats.IsCacheHit);
        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(30) + TDuration::MicroSeconds(600), stats.RespTime);
        UNIT_ASSERT_VALUES_EQUAL(117, stats.RespSize);
        UNIT_ASSERT_VALUES_EQUAL("2a02:6b8:c02:500:8000:611:0:1d", stats.Ip);
        UNIT_ASSERT_VALUES_EQUAL(line, stats.Line);
        UNIT_ASSERT(!tmpGetParams.contains("method"));
        UNIT_ASSERT(tmpGetParams.contains("format"));

        TCgiParams params;
        params["format"] = "xml";
        params["login"] = "bbtst disabled";
        params["method"] = "login";
        params["password"] = "*";
        params["userip"] = "213.180.194.68";
        UNIT_ASSERT_VALUES_EQUAL(params, stats.Params);

        line = "2019-03-13 "
               "15:40:09 "
               "e7289ef6ff2e3e4f\t"
               "http\t"
               "2a02:6b8:c02:500:8000:611:0:1d\t"
               "30.6\t"
               "1:passport_dev:2\t"
               "117\t"
               "h\t"
               "-\t"
               "-\t"
               "format=xml&login=bbtst disabled&method=login&password=*&userip=213.180.194.68";
        TTestParser::ParseLine(line, stats, tmpParams, tmpGetParams);
        UNIT_ASSERT_VALUES_EQUAL(false, stats.IsHttps);
        UNIT_ASSERT_VALUES_EQUAL(true, stats.IsCacheHit);

        line = "2019-03-13 "
               "15:40:09 "
               "e7289ef6ff2e3e4f\t"
               "http\t"
               "2a02:6b8:c02:500:8000:611:0:1d\t"
               "30.6\t"
               "1:passport_dev:2\t"
               "117\t"
               "m\t"
               "-\t"
               "format=xml&login=bbtst disabled&method=login&password=*&userip=213.180.194.68\t"
               "-";
        TTestParser::ParseLine(line, stats, tmpParams, tmpGetParams);
        UNIT_ASSERT_VALUES_EQUAL(false, stats.IsHttps);
        UNIT_ASSERT_VALUES_EQUAL(false, stats.IsCacheHit);

        line = "2019-03-13 "
               "15:40:09 "
               "e7289ef6ff2e3e4f\t"
               "http\t"
               "2a02:6b8:c02:500:8000:611:0:1d\t"
               "30.6\t"
               "1:passport_dev:2\t"
               "117\t"
               "-\t"
               "-\t"
               "-\t"
               "format=xml&login=bbtst disabled&method=login&password=*&userip=213.180.194.68\t";
        TTestParser::ParseLine(line, stats, tmpParams, tmpGetParams);
        UNIT_ASSERT_VALUES_EQUAL(false, stats.IsHttps);
        UNIT_ASSERT_VALUES_EQUAL(false, stats.IsCacheHit);
    }
}
