#include <passport/infra/daemons/blackbox/tools/reporter/access_log/src/reducer.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NBbAccess;

Y_UNIT_TEST_SUITE(Reducer) {
    class TTestReducer: public TReducer {
    public:
        using TReducer::MakeStatGroups;
    };

    void CheckEqual(const TMapper::TRes& l, const TMapper::TRes& r) {
        auto pr = [](const TMapper::TRes& res) -> TString {
            TString s;
            std::set<TString> set;
            for (const auto& pair : res) {
                set.insert(pair.first);
            }
            for (const auto& i : set) {
                s.append(i).push_back('\n');
            }
            return s;
        };

        UNIT_ASSERT_STRINGS_EQUAL(pr(l), pr(r));
    }

    TMapper::TRes CreateRes(const std::vector<TString>& files) {
        TMapper::TRes exp;
        for (const TString& s : files) {
            exp.emplace(s, TStats());
        }
        return exp;
    }

    Y_UNIT_TEST(makeStatGroups) {
        TMapper::TRes map = CreateRes({
            "/tmp/pass-load.yandex.net",
            "/tmp/pass-stress.yandex.net",
            "/tmp/pass-mimino-f100.yandex.net",
            "/tmp/pass-yateam-s-1-000.yandex.net",
            "/tmp/pass-yateam-s-1-100.yandex.net",
            "/tmp/pass-i-1-000.yandex.net",
            "/tmp/pass-m-1-100.yandex.net",
            "/tmp/pass-v-1-100.yandex.net",
        });

        TMapper::TRes prod;
        TMapper::TRes yateam;
        TMapper::TRes mimino;
        TTestReducer::MakeStatGroups(std::move(map), prod, yateam, mimino);

        CheckEqual(CreateRes({
                       "/tmp/pass-i-1-000.yandex.net",
                       "/tmp/pass-m-1-100.yandex.net",
                       "/tmp/pass-v-1-100.yandex.net",
                   }),
                   prod);
        CheckEqual(CreateRes({
                       "/tmp/pass-yateam-s-1-000.yandex.net",
                       "/tmp/pass-yateam-s-1-100.yandex.net",
                   }),
                   yateam);
        CheckEqual(CreateRes({
                       "/tmp/pass-mimino-f100.yandex.net",
                   }),
                   mimino);
    }
}
