#include <passport/infra/daemons/blackbox/tools/reporter/access_log/src/sessguard.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NBbAccess;

Y_UNIT_TEST_SUITE(Sessguard) {
    Y_UNIT_TEST(SessguardConfigReader) {
        TSessguardConfigReader reader;

        UNIT_ASSERT(!reader.GetGuards("kek"));

        const TSessguardConfigReader::TGuards* prod = reader.GetGuards("yandex");
        UNIT_ASSERT(prod);
        UNIT_ASSERT_C(prod->contains("passport"), *prod);
        UNIT_ASSERT_VALUES_EQUAL_C("passport", prod->find("passport-rc")->second, *prod);

        const TSessguardConfigReader::TGuards* team = reader.GetGuards("yandex-team");
        UNIT_ASSERT(team);
        UNIT_ASSERT_C(team->contains("passport"), *team);
        UNIT_ASSERT_VALUES_EQUAL_C("passport", team->find("passport")->second, *team);
        UNIT_ASSERT_C(team->contains("mail"), *team);
        UNIT_ASSERT_VALUES_EQUAL_C("mail", team->find("mail")->second, *team);
    }

    Y_UNIT_TEST(DetectGuardSpace) {
        TSessguardStats stats;
        UNIT_ASSERT_VALUES_EQUAL("", stats.DetectGuardSpace(""));
        UNIT_ASSERT_VALUES_EQUAL("", stats.DetectGuardSpace("yandex.ru"));
        UNIT_ASSERT_VALUES_EQUAL("", stats.DetectGuardSpace("mypassport.yandex.ru"));
        UNIT_ASSERT_VALUES_EQUAL("", stats.DetectGuardSpace("mypassport.yandex.com.tr"));

        UNIT_ASSERT_VALUES_EQUAL("passport", stats.DetectGuardSpace("my.passport.yandex.ru"));
        UNIT_ASSERT_VALUES_EQUAL("passport", stats.DetectGuardSpace("my.passport.yandex.com.tr"));
    }
}

template <>
void Out<TSessguardConfigReader::TGuards>(IOutputStream& o, const TSessguardConfigReader::TGuards& value) {
    for (const auto& [key, value] : value) {
        o << key << "->" << value << Endl;
    }
}
