#include <passport/infra/daemons/blackbox/tools/reporter/access_log/src/stats.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NBbAccess;

Y_UNIT_TEST_SUITE(Stats) {
    class TTestStats: public TStats {
    public:
        using TStats::GetMethod;
    };

    Y_UNIT_TEST(getMethod) {
        TCgiParams params = {
            {"format", "xml"},
        };

        UNIT_ASSERT_VALUES_EQUAL("", TTestStats::GetMethod(params));
        UNIT_ASSERT_VALUES_EQUAL(TCgiParams({{"format", "xml"}}), params);

        params.insert({"method", "kek"});
        UNIT_ASSERT_VALUES_EQUAL("kek", TTestStats::GetMethod(params));
        UNIT_ASSERT_VALUES_EQUAL(TCgiParams({{"format", "xml"}}), params);

        params.insert({"sessionid", "kek"});
        UNIT_ASSERT_VALUES_EQUAL("sessionid", TTestStats::GetMethod(params));
        UNIT_ASSERT_VALUES_EQUAL(TCgiParams({{"format", "xml"}, {"sessionid", "kek"}}), params);
    }
}
