#include <passport/infra/daemons/blackbox/tools/reporter/access_log/src/utils.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NBbAccess;

Y_UNIT_TEST_SUITE(Utils) {
    Y_UNIT_TEST(make_ratio) {
        UNIT_ASSERT_VALUES_EQUAL("0.0% (0.0rps[12h] - 0.0rps[24h] - 0/0)", MakeRatio(0, 0));
        UNIT_ASSERT_VALUES_EQUAL("0.0% (0.0rps[12h] - 0.0rps[24h] - 0/100)", MakeRatio(0, 100));
        UNIT_ASSERT_VALUES_EQUAL("3.5% (0.0rps[12h] - 0.0rps[24h] - 35/1000)", MakeRatio(35, 1000));
        UNIT_ASSERT_VALUES_EQUAL("1.0% (2.0rps[12h] - 1.0rps[24h] - 86400/8640000)", MakeRatio(86400, 8640000));
    }
}
