#include <passport/infra/daemons/blackbox/tools/reporter/error_log/src/mapper.h>
#include <passport/infra/daemons/blackbox/tools/reporter/error_log/src/reducer.h>
#include <passport/infra/daemons/blackbox/tools/reporter/error_log/src/robot_tokens.h>
#include <passport/infra/daemons/blackbox/tools/reporter/error_log/src/robotnets.h>

#include <library/cpp/getopt/small/last_getopt.h>

#include <util/datetime/base.h>
#include <util/stream/output.h>
#include <util/system/info.h>

using namespace NPassport;
using namespace NPassport::NBbError;

// NOLINTNEXTLINE(bugprone-exception-escape)
int main(int argc, char** argv) {
    size_t threads = NSystemInfo::NumberOfCpus();
    TString date = (TInstant::Now() - TDuration::Days(1)).FormatLocalTime("%Y%m%d");
    TString storage;
    TString outdir;

    NLastGetopt::TOpts opts;
    opts.AddHelpOption();
    opts.AddLongOption("outdir", "dir for out files")
        .DefaultValue("./")
        .StoreResult(&outdir);
    opts.AddLongOption("date", "date: %Y%m%d (default: yesterday)")
        .StoreResult(&date);
    opts.AddLongOption("storage", "path to dir with logs")
        .DefaultValue("/storage/logs/")
        .StoreResult(&storage);
    opts.AddCharOption('j', "threads (default: `nproc`)")
        .StoreResult(&threads);
    NLastGetopt::TOptsParseResult optRes(&opts, argc, argv);

    Cout << "Threads: " << threads << Endl;
    Cout << "Date   : " << date << Endl;
    Cout << "Start  : " << TInstant::Now() << Endl;

    NBbError::TRobotnets::InitLogger(outdir + "/raw.robotnets");
    NBbError::TRobotTokens::InitLogger(outdir + "/raw.robot_tokens");

    Cout << "Start mapping" << Endl;
    TInstant startMapping = TInstant::Now();
    TMapper::TRes mapResult = NReporter::TMapper::Run<TParser, TStats>(
        NReporter::TMapper::GetLogList(storage, date, "blackbox-error.log", {"*load*", "*stress*"}),
        threads);
    Cout << "Mapping finished: " << (TInstant::Now() - startMapping) << Endl;

    Cout << "Start reducing" << Endl;
    TInstant startReducing = TInstant::Now();
    TReducer::Run(outdir, std::move(mapResult), date);
    Cout << "Reducing finished: " << (TInstant::Now() - startReducing) << Endl;

    Cout << "Finish: " << TInstant::Now() << Endl;

    NBbError::TRobotnets::Reset();
    NBbError::TRobotTokens::Reset();

    return 0;
}
