#include "parser.h"

#include "robot_tokens.h"
#include "robotnets.h"

namespace NPassport::NBbError {
    void TParser::ParseLine(TStringBuf line) {
        ParseLine(line, Filename_, Stats_);
    }

    static const TString DELIM = " ";

    void TParser::ParseLine(TStringBuf line, TStringBuf filename, TStats& stats) {
        TStringBuf datetime = line.NextTok(DELIM);
        TStringBuf requestId = line.NextTok(DELIM);
        TStringBuf level = line.NextTok(DELIM);
        TStringBuf restPartOfLine = line;

        level.ChopSuffix(":");

        stats.Map(level, restPartOfLine);

        if (filename.Contains("yateam")) {
            TRobotnets::Map(datetime, restPartOfLine);
            TRobotTokens::Map(datetime, restPartOfLine);
        }

        Y_UNUSED(requestId);
    }
}
