#include "reducer.h"

namespace NPassport::NBbError {
    void TReducer::Run(const TString& dir, TMapper::TRes&& mapRes, const TString& date) {
        TMapper::TRes prod;
        TMapper::TRes yateam;
        MakeStatGroups(std::move(mapRes), prod, yateam);

        TStats sProd = ReduceStatsGroup(std::move(prod));
        TStats sYateam = ReduceStatsGroup(std::move(yateam));

        TFileOutput res(dir + "/errors.txt");
        auto printPretty = [dir, date, &res](const TStats& s, TString env) {
            const TStringBuf stars = " ********************************* ";
            res << stars << env << " *** " << date << stars << Endl;
            s.PrintPretty(res);
            res << Endl << Endl;
        };

        printPretty(sProd, "prod");
        printPretty(sYateam, "yateam");
    }

    void TReducer::MakeStatGroups(TMapper::TRes&& mapRes,
                                  TMapper::TRes& prod,
                                  TMapper::TRes& yateam) {
        for (auto& pair : mapRes) {
            const TString& filename = pair.first;

            if (filename.Contains("pass-load") || filename.Contains("pass-stress")) {
                continue;
            }

            if (filename.Contains("pass-yateam")) {
                yateam.insert(std::move(pair));
            } else {
                prod.insert(std::move(pair));
            }
        }
    }

    TStats TReducer::ReduceStatsGroup(TMapper::TRes&& group) {
        TStats res;

        for (auto& pair : group) {
            pair.second.Reduce(res);
        }

        return res;
    }
}
