#include "robot_tokens.h"

#include <passport/infra/libs/cpp/re2/regex.h>
#include <passport/infra/libs/cpp/utils/log/file_logger.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <library/cpp/string_utils/tskv_format/builder.h>

namespace NPassport::NBbError {
    static const NRe2::TRegexGroups ROBOTS_TOKENS(
        R"(OAuthProcessor: [^:]+: uid=(.*); userip=(.*); tokenid=(.*); consumer=(.*); consumer_ip=(.*);)");

    // NOLINTNEXTLINE(cppcoreguidelines-avoid-non-const-global-variables)
    static std::unique_ptr<NUtils::TFileLogger> LOGGER;

    void TRobotTokens::Map(TStringBuf datetime, TStringBuf msg) {
        std::vector<TStringBuf> groups;
        if (!msg.Contains("OAuthProcessor: ") ||
            !ROBOTS_TOKENS.PartialMatch(msg, groups)) {
            return;
        }

        NTskvFormat::TLogBuilder tskv;

        tskv.Add("datetime", datetime);
        tskv.Add("uid", groups.at(0));
        tskv.Add("userip", groups.at(1));
        tskv.Add("tokenid", groups.at(2));
        tskv.Add("consumer", groups.at(3));
        tskv.Add("consumer_ip", groups.at(4));

        LOGGER->Log(NUtils::CreateStr("tskv\t", tskv.Str()));
    }

    void TRobotTokens::InitLogger(const TString& outFile) {
        LOGGER = std::make_unique<NUtils::TFileLogger>(outFile, "DEBUG", false);
    }

    void TRobotTokens::Reset() {
        LOGGER.reset();
    }
}
