#include "robotnets.h"

#include <passport/infra/libs/cpp/re2/regex.h>
#include <passport/infra/libs/cpp/utils/log/file_logger.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <library/cpp/string_utils/tskv_format/builder.h>

namespace NPassport::NBbError {
    static const NRe2::TRegexGroups ROBOTS_NETS(
        R"(UsernetsList: [^:]+: (.*); ip=(.*); method=(.*); consumer=(.*); consumer_ip=(.*); arg value='(.*)'; decription='(.*)'; ipset=([^;]+); macro_name='([^;]*)'(; authtype='([^;]*)')?)");

    // NOLINTNEXTLINE(cppcoreguidelines-avoid-non-const-global-variables)
    static std::unique_ptr<NUtils::TFileLogger> LOGGER;

    void TRobotnets::Map(TStringBuf datetime, TStringBuf msg) {
        std::vector<TStringBuf> groups;
        if (!msg.Contains("UsernetsList: ") ||
            !ROBOTS_NETS.PartialMatch(msg, groups)) {
            return;
        }

        NTskvFormat::TLogBuilder tskv;

        tskv.Add("datetime", datetime);
        tskv.Add("result", groups.at(0));
        tskv.Add("ip", groups.at(1));
        tskv.Add("method", groups.at(2));
        tskv.Add("consumer", groups.at(3));
        tskv.Add("consumer_ip", groups.at(4));
        tskv.Add("arg", groups.at(5));
        tskv.Add("description", groups.at(6));
        tskv.Add("ipset", groups.at(7));
        tskv.Add("macro_name", groups.at(8));
        tskv.Add("authtype", groups.at(10));

        LOGGER->Log(NUtils::CreateStr("tskv\t", tskv.Str()));
    }

    void TRobotnets::InitLogger(const TString& outFile) {
        LOGGER = std::make_unique<NUtils::TFileLogger>(outFile, "DEBUG", false);
    }

    void TRobotnets::Reset() {
        LOGGER.reset();
    }
}
