#pragma once

#include <util/generic/hash.h>
#include <util/generic/noncopyable.h>
#include <util/generic/strbuf.h>

#include <list>
#include <map>
#include <optional>
#include <vector>

namespace NPassport::NBbError {
    using TLevelMessages = THashMap<TString, ui64>;

    using TCountedMessage = std::vector<std::pair<TString, ui64>>;
    void SortCountedMessage(TCountedMessage& data);

    struct TNoiseMessages {
        ui64 TotalCount = 0;
        TCountedMessage Messages;
    };
    using TNoiseMap = std::map<TString, TNoiseMessages>;

    struct TSortedMessages {
        TSortedMessages(const TLevelMessages& msg);

        TCountedMessage Common;
        std::vector<std::pair<TString, TNoiseMessages>> Noise;

    private:
        static bool IsNoise(const TString& message, ui64 count, TNoiseMap& noise);
    };

    class TStats: TMoveOnly {
    public:
        TStats();

        void Map(TStringBuf level, TStringBuf msg);

        void Reduce(TStats& to) const;
        void PrintPretty(IOutputStream& stream) const;

        enum ELevel {
            Error,
            Warning,
            Info,
            Debug,

            LevelCount,
        };

    private:
        static std::optional<ELevel> CastLevel(TStringBuf level);
        static TStringBuf CastLevel(ELevel level);

    private:
        std::vector<TLevelMessages> Data_;
    };
}
