#! /bin/sh
EMAIL=passport-stats@yandex-team.ru

set -e

trap print_err ERR

print_err()
{
    >&2 echo "failed to complete script"
}

DATE="$1"
if [[ -z $DATE || $DATE == "-" ]]; then
    DATE=$(date -d "-1 day" +'%Y%m%d')
fi

SEND_RETRIES="$2"
if [ -z $SEND_RETRIES ]; then
    SEND_RETRIES="0"
fi

BIN_DIR="/usr/bin/yandex/blackbox-reporter"
TEMPLOCATION="/storage/tmp/blackbox-reporter"
TEMPNAME="tmp"
TEMPDIR=$TEMPLOCATION"/"$TEMPNAME
ETC_DIR="/etc/yandex/blackbox-reporter"
STORAGE="/storage/logs/"

PARSER_PARAMS="--date $DATE --storage $STORAGE"

YT_PATH="//home/passport/production/reports/blackbox"

# cleanup
rm -rf $TEMPDIR
mkdir $TEMPDIR

ulimit -c unlimited

# prepare data
$BIN_DIR/blackbox_access_log_parser --outdir $TEMPDIR $PARSER_PARAMS > $TEMPDIR/access.out 2> $TEMPDIR/access.err
$BIN_DIR/blackbox_error_log_parser --outdir $TEMPDIR $PARSER_PARAMS > $TEMPDIR/error.out 2> $TEMPDIR/error.err

# send to YT before sending emails - to detect problems
export YT_TOKEN="$(cat $ETC_DIR/yt.token)"

send_to_yt_type(){
    TYPE=$1
    SCHEMA=$2
    SUBDIR=$3

    YT_TABLE=$YT_PATH"/"$TYPE"/"$DATE
    FILENAME="raw.$TYPE"
    if [ ! -z $SUBDIR ]; then
        YT_TABLE=$YT_PATH"/"$SUBDIR"/"$TYPE"/"$DATE
        FILENAME="raw.$SUBDIR.$TYPE"
    fi

    yt --proxy hahn remove -f $YT_TABLE \
    && yt --proxy hahn create table $YT_TABLE >> $TEMPDIR/yt.out 2>> $TEMPDIR/yt.err \
    && yt --proxy hahn alter-table $YT_TABLE --schema "$(cat $ETC_DIR/$SCHEMA.schema)" >> $TEMPDIR/yt.out 2>> $TEMPDIR/yt.err \
    && cat $TEMPDIR/$FILENAME | yt --proxy hahn write --format dsv --table $YT_TABLE >> $TEMPDIR/yt.out 2>> $TEMPDIR/yt.err \
    && return 0

    return 1
}

send_to_yt(){
    send_to_yt_type "prod" "yt_table" && \
    send_to_yt_type "yateam" "yt_table" && \
    send_to_yt_type "mimino" "yt_table" && \
    send_to_yt_type "robotnets" "yt_robotnets" && \
    send_to_yt_type "robot_tokens" "yt_robot_tokens" && \
    send_to_yt_type "prod" "yt_sessguard" "sessguard" && \
    send_to_yt_type "mimino" "yt_sessguard" "sessguard" && \
    send_to_yt_type "yateam" "yt_sessguard" "sessguard" && \
    return 0

    return 1
}

SENT_TO_YT=""
while [ $SEND_RETRIES -gt 0 ]
do
    if send_to_yt; then
        SENT_TO_YT="1"
        break
    else
        SEND_RETRIES=$(($SEND_RETRIES-1))
        SLEEP_PERIOD="600"
        echo "Failed to send report. Sleep for $SLEEP_PERIOD seconds" >> $TEMPDIR/yt.err
        sleep $SLEEP_PERIOD
    fi
done
if [ -z $SENT_TO_YT ]; then
    send_to_yt
fi

# too heavy
rm -rf $TEMPDIR/raw*

# send results
cat $TEMPDIR/result.prod.txt | mail -s "Blackbox prod stats" -- $EMAIL
cat $TEMPDIR/result.yateam.txt | mail -s "Blackbox yateam stats" -- $EMAIL
cat $TEMPDIR/errors.txt | mail -s "Blackbox warnings" -- $EMAIL
