#!/usr/bin/python

import base64
import sys
import time

from tool import TotpTool


def main(args):
    tool = TotpTool()

    mode = args[1]

    if mode == 'dec':
        if len(args) < 3:
            print("Too few arguments for decryption! Encrypted value unknown.")
            sys.exit(1)

        return tool.decrypt(args[2])

    elif mode == 'enc':
        if len(args) < 4:
            print("Too few arguments to encryption! At least uid and secret needed.")
            sys.exit(1)

        uid = args[2]
        secret = args[3]
        iv = args[4] if len(args) > 4 else ''

        print('Going to encrypt secret %s for user %s using iv %s' % (secret, uid, iv))

        return tool.encrypt(uid, secret, iv)

    elif mode == 'create':
        if len(args) < 6:
            print("Too few arguments to create! Uid, pin, secret_id and new secret needed.")
            sys.exit(1)

        uid = int(args[2])
        pin = args[3]
        secret_id = int(args[4])
        secret = base64.b64decode(args[5])
        iv = args[6] if len(args) > 6 else ''
        ts = int(args[7] if len(args) > 7 else time.time())

        return tool.create(uid, pin, secret_id, secret, iv, ts)

    elif mode == 'add':
        if len(args) < 5:
            print("Too few arguments to add! Secret_id, new secret and encrypted_value needed.")
            sys.exit(1)

        secret_id = int(args[2])
        secret = base64.b64decode(args[3])
        iv = args[5] if len(args) > 5 else ''
        ts = int(args[6] if len(args) > 6 else time.time())

        return tool.add(secret_id, secret, args[4], iv, ts)

    elif mode == 'del':
        if len(args) < 4:
            print("Too few arguments to delete! Secret_id and encrypted_value needed.")
            sys.exit(1)

        secret_id = int(args[2])
        iv = args[4] if len(args) > 4 else ''

        return tool.delete(secret_id, args[3], iv)
    else:
        return "Unknown mode"


if __name__ == '__main__':
    if len(sys.argv) < 3 or sys.argv[1] not in ['enc', 'dec', 'create', 'add', 'del']:
        print("Usage:")
        print("    ", sys.argv[0], "dec <encrypted_value>")
        print("    ", sys.argv[0], "enc <uid> <base64_secret> [<iv>]")
        print("    ", sys.argv[0], "create <uid> <pin> <id> <base64_secret> [<iv>] [<time>]")
        print("    ", sys.argv[0], "add <id> <base64_secret> <encrypted_value> [<iv>] [<time>]")
        print("    ", sys.argv[0], "del <id> <encrypted_value> [iv]")
        sys.exit(1)

    print(main(sys.argv))
