import argparse


SKIP = set(
    [
        145,
        156,
        234,
        508,
        568,
        675,
        845,
        847,
        848,
        850,
        851,
        861,
        863,
        866,
        867,
        871,
        872,
        874,
        879,
        880,
        882,
        887,
        889,
        905,
        907,
        909,
        956,
        981,
        1005,
        1026,
        1035,
        1053,
        1117,
        1164,
        1201,
        1380,
        1536,
        1605,
        1610,
        1741,
        1971,
        1975,
        1976,
        1977,
        1984,
        2015,
        2377,
        2461,
        2472,
        2608,
        2609,
        2825,
        2902,
        2913,
        3309,
        3312,
        3314,
        3793,
        4381,
        4403,
        4409,
        4445,
        4446,
        4447,
        4448,
        4835,
        4961,
        4974,
        5782,
        15908,
        31735,
        31752,
        31866,
        32094,
        32993,
        32997,
        34870,
    ]
)


def calc_abc_id_counts(raw_in):
    abc_id_counts = {}

    with open(raw_in, "r") as input:
        for line in input:
            tokens = line.strip().split(" ")
            abc_ids = tokens[1].split(",")
            abc_ids.reverse()

            for abc_id in abc_ids:
                abc_id = int(abc_id)
                if abc_id not in SKIP:
                    abc_id_counts[abc_id] = abc_id_counts.get(abc_id, 0) + 1
                    break

    return abc_id_counts


def run(raw_in):
    abc_id_counts = calc_abc_id_counts(raw_in)

    result = {}

    with open(raw_in, "r") as input:
        for line in input:
            tokens = line.strip().split(" ")
            abc_ids = tokens[1].split(",")
            tvm_id = int(tokens[0])
            abc_ids.reverse()

            for abc_id in abc_ids:
                abc_id = int(abc_id)
                if abc_id in SKIP:
                    continue

                if abc_id_counts.get(abc_id, 0) == 1:
                    result[tvm_id] = [abc_id, True]
                else:
                    item = result.get(tvm_id, [abc_id, False])
                    if item[1]:
                        item[0] = abc_id
                    result[tvm_id] = item

    for tvmid, counts in result.items():
        print('%s ; %s ;' % (tvmid, counts[0]))


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='prepares tasks for grants verification')
    parser.add_argument('--raw_in', type=str, help='file with tvm<->abc mapping overrides', required=True)
    args = parser.parse_args()

    run(
        args.raw_in,
    )
