#include <passport/infra/daemons/blackbox/src/badauth/kolmogor.h>

#include <passport/infra/libs/cpp/dbpool/query.h>
#include <passport/infra/libs/cpp/json/writer.h>
#include <passport/infra/libs/cpp/utils/thread_local_id.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NBb;

Y_UNIT_TEST_SUITE(Kolmogor) {
    Y_UNIT_TEST(prepareGetQuery) {
        TKolmogor::TSpaces spaces;

        UNIT_ASSERT_VALUES_EQUAL(TKolmogor::PrepareGetQuery(spaces),
                                 "{}");

        spaces.push_back({
            .Name = "some_name",
            .Keys = {},
        });
        UNIT_ASSERT_VALUES_EQUAL(
            TKolmogor::PrepareGetQuery(spaces),
            R"({"some_name":{"keys":[]}})");

        spaces[0].Keys = {{"foo", "bar"}};
        UNIT_ASSERT_VALUES_EQUAL(
            TKolmogor::PrepareGetQuery(spaces),
            R"({"some_name":{"keys":["foo","bar"]}})");

        spaces.push_back({
            .Name = "some_name_2",
            .Keys = {{"foo2", "bar2"}},
        });
        UNIT_ASSERT_VALUES_EQUAL(
            TKolmogor::PrepareGetQuery(spaces),
            R"({"some_name":{"keys":["foo","bar"]},"some_name_2":{"keys":["foo2","bar2"]}})");
    }

    Y_UNIT_TEST(prepareIncQuery) {
        TKolmogor::TSpaces spaces;

        UNIT_ASSERT_VALUES_EQUAL(TKolmogor::PrepareIncQuery(spaces),
                                 "{}");

        spaces.push_back({
            .Name = "some_name",
            .Keys = {},
        });
        UNIT_ASSERT_VALUES_EQUAL(
            TKolmogor::PrepareIncQuery(spaces),
            R"({"some_name":[{"keys":[]}]})");

        spaces[0].Keys = {{"foo", "bar"}};
        UNIT_ASSERT_VALUES_EQUAL(
            TKolmogor::PrepareIncQuery(spaces),
            R"({"some_name":[{"keys":["foo","bar"]}]})");

        spaces.push_back({
            .Name = "some_name_2",
            .Keys = {{"foo2", "bar2"}},
        });
        UNIT_ASSERT_VALUES_EQUAL(
            TKolmogor::PrepareIncQuery(spaces),
            R"({"some_name":[{"keys":["foo","bar"]}],"some_name_2":[{"keys":["foo2","bar2"]}]})");

        spaces.back().IncIfLessThan = 17;
        UNIT_ASSERT_VALUES_EQUAL(
            TKolmogor::PrepareIncQuery(spaces),
            R"({"some_name":[{"keys":["foo","bar"]}],"some_name_2":[{"inc_if_less_than":17,"keys":["foo2","bar2"]}]})");
    }

    Y_UNIT_TEST(createGetQuery) {
        TString reqid = "aaaaaaaaaaaaaaaaaaaa";
        NUtils::TRequestIdGuard g(&reqid);

        NDbPool::TQuery query = TKolmogor::CreateGetQuery("some_query");

        UNIT_ASSERT_VALUES_EQUAL(query.Query(), "/2/get");
        UNIT_ASSERT_VALUES_EQUAL(query.HttpMethod(), "POST");
        UNIT_ASSERT_VALUES_EQUAL(query.HttpBody(), "some_query");
        UNIT_ASSERT_VALUES_EQUAL(query.HttpHeaders(),
                                 NDbPool::TQuery::THttpHeaders({
                                     "Content-Type: application/json",
                                     "X-Ext-Request-Id: aaaaaaaaaaaaaaaaaaaa",
                                 }));
    }

    Y_UNIT_TEST(createIncQuery) {
        TString reqid = "aaaaaaaaaaaaaaaaaaaa";
        NUtils::TRequestIdGuard g(&reqid);

        NDbPool::TQuery query = TKolmogor::CreateIncQuery("some_query");

        UNIT_ASSERT_VALUES_EQUAL(query.Query(), "/2/inc");
        UNIT_ASSERT_VALUES_EQUAL(query.HttpMethod(), "POST");
        UNIT_ASSERT_VALUES_EQUAL(query.HttpBody(), "some_query");
        UNIT_ASSERT_VALUES_EQUAL(query.HttpHeaders(),
                                 NDbPool::TQuery::THttpHeaders({
                                     "Content-Type: application/json",
                                     "X-Ext-Request-Id: aaaaaaaaaaaaaaaaaaaa",
                                 }));
    }
}

template <>
void Out<NDbPool::TQuery::THttpHeaders>(IOutputStream& o, const NDbPool::TQuery::THttpHeaders& value) {
    for (const TString& s : value) {
        o << s << ",";
    }
}
