#include <passport/infra/daemons/blackbox/ut/common/common.h>

#include <passport/infra/daemons/blackbox/src/misc/response_cache.h>

#include <passport/infra/libs/cpp/request/test/request.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NBb;

Y_UNIT_TEST_SUITE(PasspUtCache) {
    NTest::TRequest CreateRequest() {
        NTest::TRequest request;
        request.SetConsumerFormattedName("2:mail");
        request.InHeaders.insert({"Authorization", "ololo"});
        request.RequestBody = "mega body &a=value&&";
        request.RequestCgi = "b=kek&a=value&&otherparam=yes%26login%3Dimperator";
        return request;
    }

    Y_UNIT_TEST(defaultCtor) {
        TResponseCache::TCacheHolder h;
        NCache::EStatus status;
        UNIT_ASSERT(!h.GetValue(status));
        UNIT_ASSERT_VALUES_EQUAL(NCache::EStatus::Unacceptable, status);
        UNIT_ASSERT_NO_EXCEPTION(h.PutValue(std::make_shared<TString>()));

        NTest::TRequest request = CreateRequest();
        request.SetConsumerFormattedName("1:mail");
        UNIT_ASSERT_STRINGS_EQUAL("", h.BuildKey(request, "YT"));
    }

    Y_UNIT_TEST(common) {
        auto ctx = std::make_shared<TResponseCache::TContext>(100, "some_uni_name");
        auto cache = ctx->CreateCache(3, 16, "userinfo");

        TResponseCache::TCacheHolder h(cache, TDuration::Seconds(1), false);

        NTest::TRequest request = CreateRequest();
        UNIT_ASSERT_STRINGS_EQUAL("tvm|YT|ololo|&a=value&b=kek&mega body &otherparam=yes%26login%3Dimperator&",
                                  h.BuildKey(request, "YT"));

        NCache::EStatus status;
        UNIT_ASSERT(!h.GetValue(status));
        UNIT_ASSERT_VALUES_EQUAL(NCache::EStatus::Miss, status);
        h.PutValue(std::make_shared<TString>("kek"));
        h.BuildKey(request, "YT");
        UNIT_ASSERT_STRINGS_EQUAL("kek", *h.GetValue(status));
        UNIT_ASSERT_VALUES_EQUAL(NCache::EStatus::Hit, status);
    }

    Y_UNIT_TEST(dryRun) {
        auto ctx = std::make_shared<TResponseCache::TContext>(100, "some_uni_name");
        auto cache = ctx->CreateCache(3, 16, "userinfo");

        TResponseCache::TCacheHolder h(cache, TDuration::Seconds(1), true);
        NCache::EStatus status;
        UNIT_ASSERT_EXCEPTION_CONTAINS(h.GetValue(status), yexception, "Key for cache cannot be empty");
        UNIT_ASSERT_EXCEPTION_CONTAINS(h.PutValue(std::make_shared<TString>()), yexception, "Key for cache cannot be empty");

        NTest::TRequest request = CreateRequest();
        UNIT_ASSERT_STRINGS_EQUAL("tvm|YT|ololo|&a=value&b=kek&mega body &otherparam=yes%26login%3Dimperator&",
                                  h.BuildKey(request, "YT"));

        UNIT_ASSERT(!h.GetValue(status));
        UNIT_ASSERT_VALUES_EQUAL(NCache::EStatus::Miss, status);
        h.PutValue(std::make_shared<TString>("kek"));
        h.BuildKey(request, "YT");
        UNIT_ASSERT(!h.GetValue(status));
        UNIT_ASSERT_VALUES_EQUAL(NCache::EStatus::Hit, status);
    }
}
