#pragma once

#include "domain_fetcher_mock.h"

#include <passport/infra/daemons/blackbox/src/blackbox.h>
#include <passport/infra/daemons/blackbox/src/domain/notimplemented_domain_fetcher.h>
#include <passport/infra/daemons/blackbox/src/loggers/tskvlog.h>
#include <passport/infra/daemons/blackbox/src/misc/db_fetcher.h>
#include <passport/infra/daemons/blackbox/src/misc/db_profile.h>
#include <passport/infra/daemons/blackbox/src/misc/dbfields_converter.h>
#include <passport/infra/daemons/blackbox/src/misc/hosts_list.h>
#include <passport/infra/daemons/blackbox/src/misc/shards_map.h>
#include <passport/infra/daemons/blackbox/src/oauth/config.h>
#include <passport/infra/daemons/blackbox/src/oauth/fetcher.h>
#include <passport/infra/daemons/blackbox/src/totp/totp_encryptor.h>
#include <passport/infra/daemons/blackbox/src/totp/totp_profile.h>

#include <library/cpp/openssl/init/init.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/string.h>

class TPasspDbProfileTestSuite;
class TPasspBbHelpersAccountHelperTestSuite;
class TPasspBbHelpersDisplayNameHelperTestSuite;

namespace NPassport::NBb {
    TString TestsDir();
    void PrepareConfig(const TString& name, const TString& testPath);

    class TTestDbFetcher: public TDbFetcher {
    public:
        using TDbFetcher::GetAttrsCondition;
        using TDbFetcher::TDbFetcher;

        const TDbProfile& DefaultProfile() const;

        void SetTotpEncryptor(const TTotpEncryptor& encryptor);
    };

    class TTestOAuthFetcher: public TOAuthSingleFetcher {
    public:
        using TOAuthSingleFetcher::AddClientAttrs_;
        using TOAuthSingleFetcher::AllClientAttrs_;
        using TOAuthSingleFetcher::TAttrSet;
        using TOAuthSingleFetcher::TOAuthSingleFetcher;
    };

    class TTestDbHolder {
    public:
        TTestDbHolder();

        std::unique_ptr<TTestDbFetcher> CreateFetcher();
        std::unique_ptr<TTestDbFetcher> CreateFetcher(IDomainFetcher& domainfetcher);
        std::unique_ptr<TDbFieldsConverter> CreateConverter(TDbFetcher& fetcher);
        std::unique_ptr<TDbFieldsConverter> CreateConverter(TDbFetcher& fetcher, const std::vector<TString>& sids);
        std::unique_ptr<TTestOAuthFetcher> CreateOAuthFetcher();
        const TOAuthConfig& GetOAuthConfig() const;
        std::unique_ptr<TTestDbFetcher> GetMockedDbFetcher(TDomainFetcherMock& domainFetcher, TString domainId = TString(), bool addAliases = false);

        const TRangedShardsMap& GetShards() {
            return *DbShards_;
        }

        static TTestDbHolder& GetSingleton();

    private:
        std::unique_ptr<NDbPool::TDbPool> Pool_;
        std::unique_ptr<TRangedShardsMap> DbShards_;
        std::unique_ptr<THostsList> Hosts_;
        std::unique_ptr<TTskvLog> OauthLog_;
        std::unique_ptr<TOAuthConfig> OauthConfig_;
        TNotImplementedDomainFetcher NotImplementedDomainFetcher_;
    };

    class TTestDbProfile: public TDbProfile {
    public:
        friend class ::TPasspDbProfileTestSuite;
        friend class ::TPasspBbHelpersAccountHelperTestSuite;
        friend class ::TPasspBbHelpersDisplayNameHelperTestSuite;

        TTestDbProfile(const TDbProfile& d)
            : TDbProfile(d)
        {
        }

        using TDbProfile::ExtendedPhoneAttrs;
        TExtendedEntities& ExtendedPhoneAttrs() {
            return ExtendedPhones_;
        }

        using TDbProfile::ExtendedEmailAttrs;
        TExtendedEntities& ExtendedEmailAttrs() {
            return ExtendedEmails_;
        }

        using TDbProfile::AddAlias;
        using TDbProfile::AddAttr;
        using TDbProfile::Aliases_;
        using TDbProfile::AliasesOldPublic_;
        using TDbProfile::AliasesPdd_;
        using TDbProfile::Attrs_;
        using TDbProfile::CatchAll_;
        using TDbProfile::DefaultPhoneId_;
        using TDbProfile::DomCache_;
        using TDbProfile::DomItem_;
        using TDbProfile::Empty_;
        using TDbProfile::ExtendedPhones_;
        using TDbProfile::FamilyInfo_;
        using TDbProfile::NeedFamilyInfo_;
        using TDbProfile::NeedPhoneOperations_;
        using TDbProfile::PhoneBindingsType_;
        using TDbProfile::Suid2_;
        using TDbProfile::TDbProfile;
        using TDbProfile::Uid_;

        void SetUid(const TString& uid);
        TDbIndex AddAlias(const TString& type, const TString& val);
        void AddPddAlias(const TString& val);
        void AddOldPublicAlias(const TString& val);
        TDbIndex AddAttr(const TString& type, const TString& val);
        void AddPhoneAttr(const TString& id, const TString& type, const TString& val);
        void AddEmailAttr(const TString& id, const TString& type, const TString& val);
        void AddWebauthnAttr(const TString& id, const TString& type, const TString& val);

        void FillWithSampleData();
        bool IsEmpty() const;
    };

    class TTestTotpProfile: public TTotpProfile {
    public:
        using TTotpProfile::AddSecret;
        using TTotpProfile::TTotpProfile;
    };

    TTotpEncryptor CreateTotpEncryptor();

    class TBbHolder {
    public:
        TBbHolder();

        std::unique_ptr<NPassport::NBb::TBlackbox> Bb;
    };

    class TBlackboxFixture: public NUnitTest::TBaseFixture, public TBbHolder {
    };

    void SetLocalTimeZone();
}
